<?php
/**
 * The template for displaying header navigation.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

?>

<nav class="site-navigation main-navigation blogun-primary-nav blogun-nav blogun-header-element" role="navigation"<?php blogun_schema_markup( 'site_navigation' ); ?> aria-label="<?php esc_attr_e( 'Site Navigation', 'blogun' ); ?>">

<?php

if ( has_nav_menu( 'blogun-primary' ) ) {
	wp_nav_menu(
		array(
			'theme_location' => 'blogun-primary',
			'menu_id'        => 'blogun-primary-nav',
			'container'      => '',
			'link_before'    => '<span>',
			'link_after'     => '</span>',
		)
	);
} else {
	wp_page_menu(
		array(
			'menu_class'  => 'blogun-primary-nav',
			'show_home'   => true,
			'container'   => 'ul',
			'before'      => '',
			'after'       => '',
			'link_before' => '<span>',
			'link_after'  => '</span>',
		)
	);
}

?>
</nav><!-- END .blogun-nav -->
