<?php
/**
 * The template for displaying header layout 4.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

?>

<div class="blogun-header-container">
	<div class="blogun-logo-container">
		<div class="blogun-container">

			<?php
			blogun_header_logo_template();
			?>

			<?php
			$header_ads_banner_custom_image  = blogun()->options->get( 'blogun_header_ads_banner' );
			$header_ads_banner_custom_url    = blogun()->options->get( 'blogun_header_ads_banner_url' );
			$header_ads_banner_custom_target = blogun()->options->get( 'blogun_header_ads_banner_url_target' );

			$adsbanner = $header_ads_banner_custom_url ? sprintf( '<a href="%1$s" target="' . esc_attr( $header_ads_banner_custom_target ) . '"><img src="%2$s"/></a>', esc_url_raw( $header_ads_banner_custom_url ), esc_url_raw( $header_ads_banner_custom_image ) ) : sprintf( '<img src="%1$s"/>', esc_url_raw( $header_ads_banner_custom_image ) );

			if ( $header_ads_banner_custom_image ) {
				?>

			<!-- Header Image -->
			<div class="blogun-header-widgets blogun-header-widgets-two blogun-header-element">
				<div class="blogun-header-widget__image blogun-header-widget blogun-all">
					<div class="blogun-widget-wrapper">
						<div class="ads-banner">
							<?php echo wp_kses_post( $adsbanner ); ?>
						</div><!-- .ads-banner -->
					</div>
				</div>
			</div>
			<?php } ?>

			<?php
			do_action( 'blogun_header_widget_location', array( 'left', 'right' ) );
			?>

			<span class="blogun-header-element blogun-mobile-nav">
				<?php blogun_hamburger( blogun_option( 'main_nav_mobile_label' ), 'blogun-primary-nav' ); ?>
				<?php blogun_main_navigation_template(); ?>
			</span>

		</div><!-- END .blogun-container -->
	</div><!-- END .blogun-logo-container -->

	<div class="blogun-nav-container">
		<div class="blogun-container">

			<?php
			do_action( 'blogun_header_widget_location', 'left' );
			blogun_main_navigation_template();
			do_action( 'blogun_header_widget_location', 'right' );
			?>

		</div><!-- END .blogun-container -->
	</div><!-- END .blogun-nav-container -->
</div><!-- END .blogun-header-container -->
