<?php
/**
 * Template part for displaying page header.
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

?>

<div <?php blogun_page_header_classes(); ?><?php blogun_page_header_atts(); ?>>
	<div class="blogun-container">

	<?php do_action( 'blogun_page_header_start' ); ?>

	<?php if ( blogun_page_header_has_title() ) { ?>

		<div class="blogun-page-header-wrapper">

			<div class="blogun-page-header-title">
				<?php blogun_page_header_title(); ?>
			</div>

			<?php $blogun_description = apply_filters( 'blogun_page_header_description', blogun_get_the_description() ); ?>

			<?php if ( $blogun_description ) { ?>

				<div class="blogun-page-header-description">
					<?php echo wp_kses( $blogun_description, blogun_get_allowed_html_tags() ); ?>
				</div>

			<?php } ?>
		</div>

	<?php } ?>

	<?php do_action( 'blogun_page_header_end' ); ?>

	</div>
</div>
