<?php
/**
 * Template part for displaying page header for single post.
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

?>

<div <?php blogun_page_header_classes(); ?><?php blogun_page_header_atts(); ?>>

	<?php do_action( 'blogun_page_header_start' ); ?>

	<?php if ( 'in-page-header' === blogun_option( 'single_title_position' ) ) { ?>

		<div class="blogun-container">
			<div class="blogun-page-header-wrapper">

				<?php
				if ( blogun_single_post_displays( 'category' ) ) {
					get_template_part( 'template-parts/entry/entry', 'category' );
				}

				if ( blogun_page_header_has_title() ) {
					echo '<div class="blogun-page-header-title">';
					blogun_page_header_title();
					echo '</div>';
				}

				if ( blogun_has_entry_meta_elements() ) {
					get_template_part( 'template-parts/entry/entry', 'meta' );
				}
				?>

			</div>
		</div>

	<?php } ?>

	<?php do_action( 'blogun_page_header_end' ); ?>

</div>
