<?php
/**
 * Template part for displaying entry thumbnail (featured image).
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get default post media.
$blogun_media = blogun_get_post_media( '' );

if ( ! $blogun_media || post_password_required() ) {
	return;
}

$blogun_post_format = get_post_format();

// Wrap with link for non-singular pages.
if ( 'link' === $blogun_post_format || ! is_single( get_the_ID() ) ) {

	$blogun_icon = '';

	if ( is_sticky() ) {
		$blogun_icon = sprintf(
			'<span class="entry-media-icon is_sticky" title="%1$s" aria-hidden="true"><span class="entry-media-icon-wrapper">%2$s%3$s</span></span>',
			esc_attr__( 'Featured', 'blogun' ),
			blogun()->icons->get_svg(
				'pin',
				array(
					'class'       => 'top-icon',
					'aria-hidden' => 'true',
				)
			),
			blogun()->icons->get_svg( 'pin', array( 'aria-hidden' => 'true' ) )
		);
	} elseif ( 'video' === $blogun_post_format ) {
		$blogun_icon = sprintf(
			'<span class="entry-media-icon" aria-hidden="true"><span class="entry-media-icon-wrapper">%1$s%2$s</span></span>',
			blogun()->icons->get_svg(
				'play',
				array(
					'class'       => 'top-icon',
					'aria-hidden' => 'true',
				)
			),
			blogun()->icons->get_svg( 'play', array( 'aria-hidden' => 'true' ) )
		);
	} elseif ( 'link' === $blogun_post_format ) {
		$blogun_icon = sprintf(
			'<span class="entry-media-icon" title="%1$s" aria-hidden="true"><span class="entry-media-icon-wrapper">%2$s%3$s</span></span>',
			esc_url( blogun_entry_get_permalink() ),
			blogun()->icons->get_svg(
				'external-link',
				array(
					'class'       => 'top-icon',
					'aria-hidden' => 'true',
				)
			),
			blogun()->icons->get_svg( 'external-link', array( 'aria-hidden' => 'true' ) )
		);
	}

	$blogun_icon = apply_filters( 'blogun_post_format_media_icon', $blogun_icon, $blogun_post_format );

	$blogun_media = sprintf(
		'<a href="%1$s" class="entry-image-link">%2$s%3$s</a>',
		esc_url( blogun_entry_get_permalink() ),
		$blogun_media,
		$blogun_icon
	);
}

$blogun_media = apply_filters( 'blogun_post_thumbnail', $blogun_media );

// Print the post thumbnail.
echo wp_kses(
	sprintf(
		'<div class="post-thumb entry-media thumbnail">%1$s</div>',
		$blogun_media
	),
	blogun_get_allowed_html_tags()
);
