<?php
/**
 * Template part for displaying page featured image.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get default post media.
$blogun_media = blogun_get_post_media( '' );

if ( ! $blogun_media || post_password_required() ) {
	return;
}

$blogun_media = apply_filters( 'blogun_post_thumbnail', $blogun_media, get_the_ID() );

$blogun_classes = array( 'post-thumb', 'entry-media', 'thumbnail' );

$blogun_classes = apply_filters( 'blogun_post_thumbnail_wrapper_classes', $blogun_classes, get_the_ID() );
$blogun_classes = trim( implode( ' ', array_unique( $blogun_classes ) ) );

// Print the post thumbnail.
echo wp_kses_post(
	sprintf(
		'<div class="%2$s">%1$s</div>',
		$blogun_media,
		esc_attr( $blogun_classes )
	)
);
