<?php
/**
 * Template part for displaying entry footer.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<?php do_action( 'blogun_before_entry_footer' ); ?>
<footer class="entry-footer">
	<?php

	// Allow text to be filtered.
	$blogun_read_more_text = apply_filters( 'blogun_entry_read_more_text', __( 'Read More', 'blogun' ) );

	?>
	<a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>" class="blogun-btn btn-text-1"><span><?php echo esc_html( $blogun_read_more_text ); ?></span></a>
</footer>
<?php do_action( 'blogun_after_entry_footer' ); ?>
