<?php
/**
 * Template part for displaying ”Show Comments” button.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

// Do not show if the post is password protected.
if ( post_password_required() ) {
	return;
}

$blogun_comment_count = get_comments_number();
$blogun_comment_title = esc_html__( 'Leave a Comment', 'blogun' );

if ( $blogun_comment_count > 0 ) {
	/* translators: %s is comment count */
	$blogun_comment_title = esc_html( sprintf( _n( 'Show %s Comment', 'Show %s Comments', $blogun_comment_count, 'blogun' ), $blogun_comment_count ) );
}

?>
<a href="#" id="blogun-comments-toggle" class="blogun-btn btn-large btn-fw btn-left-icon">
	<?php echo blogun()->icons->get_svg( 'chat' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	<span><?php echo $blogun_comment_title; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
</a>
