<?php
/**
 * Template part for displaying entry meta info.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Only show meta tags for posts.
 */
if ( ! in_array( get_post_type(), (array) apply_filters( 'blogun_entry_meta_post_type', array( 'post' ) ), true ) ) {
	return;
}

do_action( 'blogun_before_entry_meta' );

// Get meta items to be displayed.
$blogun_meta_elements = blogun_get_entry_meta_elements();

if ( ! empty( $blogun_meta_elements ) ) {

	echo '<div class="entry-meta"><div class="entry-meta-elements">';

	do_action( 'blogun_before_entry_meta_elements' );

	// Loop through meta items.
	foreach ( $blogun_meta_elements as $blogun_meta_item ) {

		// Call a template tag function.
		if ( function_exists( 'blogun_entry_meta_' . $blogun_meta_item ) ) {
			call_user_func( 'blogun_entry_meta_' . $blogun_meta_item );
		}
	}

	// Add edit post link.
	$blogun_edit_icon = blogun()->icons->get_meta_icon( 'edit', blogun()->icons->get_svg( 'edit-3', array( 'aria-hidden' => 'true' ) ) );

	blogun_edit_post_link(
		sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				$blogun_edit_icon . __( 'Edit <span class="screen-reader-text">%s</span>', 'blogun' ),
				blogun_get_allowed_html_tags()
			),
			get_the_title()
		),
		'<span class="edit-link">',
		'</span>'
	);

	do_action( 'blogun_after_entry_meta_elements' );

	echo '</div></div>';
}

do_action( 'blogun_after_entry_meta' );
