<?php
/**
 * Template part for displaying entry header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<?php do_action( 'blogun_before_entry_header' ); ?>
<header class="entry-header">

	<?php
	$blogun_tag = is_single( get_the_ID() ) && ! blogun_page_header_has_title() ? 'h1' : 'h4';
	$blogun_tag = apply_filters( 'blogun_entry_header_tag', $blogun_tag );

	$blogun_title_string = '%2$s%1$s';

	if ( 'link' === get_post_format() ) {
		$blogun_title_string = '<a href="%3$s" title="%3$s" rel="bookmark">%2$s%1$s</a>';
	} elseif ( ! is_single( get_the_ID() ) ) {
		$blogun_title_string = '<a href="%3$s" title="%4$s" rel="bookmark">%2$s%1$s</a>';
	}

	$blogun_title_icon = apply_filters( 'blogun_post_title_icon', '' );
	$blogun_title_icon = blogun()->icons->get_svg( $blogun_title_icon );
	?>

	<<?php echo tag_escape( $blogun_tag ); ?> class="entry-title"<?php blogun_schema_markup( 'headline' ); ?>>
		<?php
		echo sprintf(
			wp_kses_post( $blogun_title_string ),
			wp_kses_post( get_the_title() ),
			wp_kses_post( (string) $blogun_title_icon ),
			esc_url( blogun_entry_get_permalink() ),
			the_title_attribute( array( 'echo' => false ) )
		);
		?>
	</<?php echo tag_escape( $blogun_tag ); ?>>

</header>
<?php do_action( 'blogun_after_entry_header' ); ?>
