<?php
/**
 * Template part for displaying entry tags.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

$blogun_entry_elements    = blogun_option( 'single_post_elements' );
$blogun_entry_footer_tags = isset( $blogun_entry_elements['tags'] ) && $blogun_entry_elements['tags'] && has_tag();
$blogun_entry_footer_date = isset( $blogun_entry_elements['last-updated'] ) && $blogun_entry_elements['last-updated'] && get_the_time( 'U' ) !== get_the_modified_time( 'U' );

$blogun_entry_footer_tags = apply_filters( 'blogun_display_entry_footer_tags', $blogun_entry_footer_tags );
$blogun_entry_footer_date = apply_filters( 'blogun_display_entry_footer_date', $blogun_entry_footer_date );

// Nothing is enabled, don't display the div.
if ( ! $blogun_entry_footer_tags && ! $blogun_entry_footer_date ) {
	return;
}
?>

<?php do_action( 'blogun_before_entry_footer' ); ?>

<div class="entry-footer">

	<?php
	// Post Tags.
	if ( $blogun_entry_footer_tags ) {
		blogun_entry_meta_tag(
			'<div class="post-tags"><span class="cat-links">',
			'',
			'</span></div>',
			0,
			false
		);
	}

	// Last Updated Date.
	if ( $blogun_entry_footer_date ) {

		$blogun_before = '<span class="last-updated blogun-iflex-center">';

		if ( true === blogun_option( 'single_entry_meta_icons' ) ) {
			$blogun_before .= blogun()->icons->get_svg( 'edit-3' );
		}

		blogun_entry_meta_date(
			array(
				'show_published' => false,
				'show_modified'  => true,
				'before'         => $blogun_before,
				'after'          => '</span>',
			)
		);
	}
	?>

</div>

<?php do_action( 'blogun_after_entry_footer' ); ?>
