<?php
/**
 * Template part for displaying post in post listing.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

?>

<?php do_action( 'blogun_before_article' ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'blogun-article' ); ?><?php blogun_schema_markup( 'article' ); ?>>

	<?php
	$blogun_blog_entry_format = get_post_format();

	if ( 'quote' === $blogun_blog_entry_format ) {
		get_template_part( 'template-parts/entry/format/media', $blogun_blog_entry_format );
	} else {

		$blogun_blog_entry_elements = blogun_get_blog_entry_elements();

		if ( ! empty( $blogun_blog_entry_elements ) ) {
			foreach ( $blogun_blog_entry_elements as $blogun_element ) {
				get_template_part( 'template-parts/entry/entry', $blogun_element );
			}
		}
	}
	?>

</article><!-- #post-<?php the_ID(); ?> -->

<?php do_action( 'blogun_after_article' ); ?>
