<?php
/**
 * Template for Single post
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

?>

<?php do_action( 'blogun_before_article' ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'blogun-article' ); ?><?php blogun_schema_markup( 'article' ); ?>>

	<?php
	if ( 'quote' === get_post_format() ) {
		get_template_part( 'template-parts/entry/format/media', 'quote' );
	}

	$blogun_single_post_elements = blogun_get_single_post_elements();

	if ( ! empty( $blogun_single_post_elements ) ) {
		foreach ( $blogun_single_post_elements as $blogun_element ) {

			if ( 'content' === $blogun_element ) {
				do_action( 'blogun_before_single_content' );
				get_template_part( 'template-parts/entry/entry', $blogun_element );
				do_action( 'blogun_after_single_content' );
			} else {
				get_template_part( 'template-parts/entry/entry', $blogun_element );
			}
		}
	}
	?>

</article><!-- #post-<?php the_ID(); ?> -->

<?php do_action( 'blogun_after_article' ); ?>
