<?php
/**
 * The template for displaying theme sidebar.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

if ( ! blogun_is_sidebar_displayed() ) {
	return;
}

$blogun_sidebar = blogun_get_sidebar();
?>

<aside id="secondary" class="widget-area blogun-sidebar-container"<?php blogun_schema_markup( 'sidebar' ); ?> role="complementary">

	<div class="blogun-sidebar-inner">
		<?php do_action( 'blogun_before_sidebar' ); ?>

		<?php
		if ( is_active_sidebar( $blogun_sidebar ) ) {

			dynamic_sidebar( $blogun_sidebar );

		} elseif ( current_user_can( 'edit_theme_options' ) ) {

			$blogun_sidebar_name = blogun_get_sidebar_name_by_id( $blogun_sidebar );
			?>
			<div class="blogun-sidebar-widget blogun-widget blogun-no-widget">

				<div class='h4 widget-title'><?php echo esc_html( $blogun_sidebar_name ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div> 

				<p class='no-widget-text'>
					<?php if ( is_customize_preview() ) { ?>
						<a href='#' class="blogun-set-widget" data-sidebar-id="<?php echo esc_attr( $blogun_sidebar ); ?>">
					<?php } else { ?>
						<a href='<?php echo esc_url( admin_url( 'widgets.php' ) ); ?>'>
					<?php } ?>
						<?php esc_html_e( 'Click here to assign a widget.', 'blogun' ); ?>
					</a>
				</p>
			</div>
			<?php
		}
		?>

		<?php do_action( 'blogun_after_sidebar' ); ?>
	</div>

</aside><!--#secondary .widget-area -->

<?php
