<?php
/**
 * The template for displaying search form.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Support for custom search post type.
$blogun_post_type = apply_filters( 'blogun_search_post_type', 'all' );
$blogun_post_type = 'all' !== $blogun_post_type ? '<input type="hidden" name="post_type" value="' . esc_attr( $blogun_post_type ) . '" />' : '';
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div>
		<input type="search" class="search-field" aria-label="<?php esc_attr_e( 'Enter search keywords', 'blogun' ); ?>" placeholder="<?php esc_attr_e( 'Search', 'blogun' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
		<?php echo $blogun_post_type; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>

		<button role="button" type="submit" class="search-submit" aria-label="<?php esc_attr_e( 'Search', 'blogun' ); ?>">
			<?php echo blogun()->icons->get_svg( 'search', array( 'aria-hidden' => 'true' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</button>
	</div>
</form>
