<?php
/**
 * Blogun Base Typography section in Customizer.
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Typography' ) ) :
	/**
	 * Blogun Typography section in Customizer.
	 */
	class Blogun_Customizer_Typography {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_typography'] = array(
				'title'    => esc_html__( 'Base Typography', 'blogun' ),
				'panel'    => 'blogun_panel_general',
				'priority' => 30,
			);

			// Headings typography heading.
			$options['setting']['blogun_typography_body_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Body & Content', 'blogun' ),
					'section' => 'blogun_section_typography',
				),
			);

			// Body Font.
			$options['setting']['blogun_body_font'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_typography',
				'control'           => array(
					'type'     => 'blogun-typography',
					'label'    => esc_html__( 'Body Typography', 'blogun' ),
					'section'  => 'blogun_section_typography',
					'display'  => array(
						'font-family'     => array(),
						'font-subsets'    => array(),
						'font-weight'     => array(),
						'font-style'      => array(),
						'text-transform'  => array(),
						'text-decoration' => array(),
						'letter-spacing'  => array(),
						'font-size'       => array(),
						'line-height'     => array(),
					),
					'required' => array(
						array(
							'control'  => 'blogun_typography_body_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_Typography();
