<?php
/**
 * Blogun Top Bar Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Top_Bar' ) ) :
	/**
	 * Blogun Top Bar Settings section in Customizer.
	 */
	class Blogun_Customizer_Top_Bar {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_top_bar'] = array(
				'title'    => esc_html__( 'Top Bar', 'blogun' ),
				'panel'    => 'blogun_panel_header',
				'priority' => 10,
			);

			// Enable Top Bar.
			$options['setting']['blogun_top_bar_enable'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Enable Top Bar', 'blogun' ),
					'description' => esc_html__( 'Top Bar is a section with widgets located above Main Header area.', 'blogun' ),
					'section'     => 'blogun_section_top_bar',
				),
			);

			// Top Bar widgets heading.
			$options['setting']['blogun_top_bar_heading_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-heading',
					'label'       => esc_html__( 'Top Bar Widgets', 'blogun' ),
					'description' => esc_html__( 'Click the Add Widget button to add available widgets to your Top Bar.', 'blogun' ),
					'section'     => 'blogun_section_top_bar',
					'required'    => array(
						array(
							'control'  => 'blogun_top_bar_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Top Bar widgets.
			$options['setting']['blogun_top_bar_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_widget',
				'control'           => array(
					'type'       => 'blogun-widget',
					'label'      => esc_html__( 'Top Bar Widgets', 'blogun' ),
					'section'    => 'blogun_section_top_bar',
					'widgets'    => array(
						'text'    => array(
							'max_uses' => 1,
						),
						'nav'     => array(
							'max_uses' => 1,
						),
						'socials' => array(
							'max_uses' => 1,
							'styles'   => array(
								'minimal' => esc_html__( 'Minimal', 'blogun' ),
								'rounded' => esc_html__( 'Rounded', 'blogun' ),
								'minimal-fill' => esc_html__( 'Minimal Fill', 'blogun' ),
								'rounded-fill' => esc_html__( 'Rounded Fill', 'blogun' ),
							),
							'sizes'     => array(
								'small' => esc_html__( 'Small', 'blogun' ),
								'standard' => esc_html__( 'Standard', 'blogun' ),
								'large' => esc_html__( 'Large', 'blogun' ),
								'xlarge' => esc_html__( 'Extra Large', 'blogun' ),
							),
						),
					),
					'locations'  => array(
						'left'  => esc_html__( 'Left', 'blogun' ),
						'right' => esc_html__( 'Right', 'blogun' ),
					),
					'visibility' => array(
						'all'                => esc_html__( 'Show on All Devices', 'blogun' ),
						'hide-mobile'        => esc_html__( 'Hide on Mobile', 'blogun' ),
						'hide-tablet'        => esc_html__( 'Hide on Tablet', 'blogun' ),
						'hide-mobile-tablet' => esc_html__( 'Hide on Mobile and Tablet', 'blogun' ),
					),
					'required'   => array(
						array(
							'control'  => 'blogun_top_bar_heading_widgets',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_top_bar_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#blogun-topbar',
					'render_callback'     => 'blogun_topbar_output',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Top Bar design options heading.
			$options['setting']['blogun_top_bar_heading_design_options'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Design Options', 'blogun' ),
					'section'  => 'blogun_section_top_bar',
					'required' => array(
						array(
							'control'  => 'blogun_top_bar_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Top Bar Background.
			$options['setting']['blogun_top_bar_background'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Background', 'blogun' ),
					'section'  => 'blogun_section_top_bar',
					'display'  => array(
						'background' => array(
							'color'    => esc_html__( 'Solid Color', 'blogun' ),
							'gradient' => esc_html__( 'Gradient', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_top_bar_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_top_bar_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Top Bar Text Color.
			$options['setting']['blogun_top_bar_text_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Font Color', 'blogun' ),
					'section'  => 'blogun_section_top_bar',
					'display'  => array(
						'color' => array(
							'text-color'       => esc_html__( 'Text Color', 'blogun' ),
							'link-color'       => esc_html__( 'Link Color', 'blogun' ),
							'link-hover-color' => esc_html__( 'Link Hover Color', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_top_bar_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_top_bar_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Top_Bar();
