<?php
/**
 * Blogun Ticker section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Ticker' ) ) :
	/**
	 * Blogun Ticker section in Customizer.
	 */
	class Blogun_Customizer_Ticker {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {
			// Ticker News Section.
			$options['section']['blogun_section_ticker'] = array(
				'title'    => esc_html__( 'Ticker News', 'blogun' ),
				'priority' => 3,
			);

			// Ticker News enable.
			$options['setting']['blogun_enable_ticker'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'section' => 'blogun_section_ticker',
					'label'   => esc_html__( 'Enable Ticker News Section', 'blogun' ),
				),
			);

			// Title.
			$options['setting']['blogun_ticker_title'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
				'control'           => array(
					'type'     => 'blogun-text',
					'section'  => 'blogun_section_ticker',
					'label'    => esc_html__( 'Title', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Ticker News display on.
			$options['setting']['blogun_ticker_enable_on'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_no_sanitize',
				'control'           => array(
					'type'        => 'blogun-checkbox-group',
					'label'       => esc_html__( 'Enable On: ', 'blogun' ),
					'description' => esc_html__( 'Choose on which pages you want to enable Ticker News. ', 'blogun' ),
					'section'     => 'blogun_section_ticker',
					'choices'     => array(
						'home'       => array(
							'title' => esc_html__( 'Home Page', 'blogun' ),
						),
						'posts_page' => array(
							'title' => esc_html__( 'Blog / Posts Page', 'blogun' ),
						),
						'archive'    => array(
							'title' => esc_html__( 'Archive Page', 'blogun' ),
						),
						'search'     => array(
							'title' => esc_html__( 'Search Page', 'blogun' ),
						),
						'post'       => array(
							'title' => esc_html__( 'Single Post', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Ticker Slider heading.
			$options['setting']['blogun_ticker_style'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_ticker',
					'label'    => esc_html__( 'Style', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_type',
							'value'    => 'hover-slider',
							'operator' => '==',
						),
					),
				),
			);

			// Ticker Slider Elements.
			$options['setting']['blogun_ticker_elements'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_ticker',
					'label'       => esc_html__( 'Post Elements', 'blogun' ),
					'sortable'    => false,
					'choices'     => array(
						// 'thumbnail' => esc_html__( 'Thumbnail', 'blogun' ),
						'meta' => esc_html__( 'Post Date', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_style',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_type',
							'value'    => 'hover-slider',
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#ticker',
					'render_callback'     => 'blogun_blog_ticker',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Post Settings heading.
			$options['setting']['blogun_ticker_posts'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_ticker',
					'label'    => esc_html__( 'Post Settings', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_type',
							'value'    => 'hover-slider',
							'operator' => '==',
						),
					),
				),
			);

			// Post count.
			$options['setting']['blogun_ticker_post_number'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_ticker',
					'label'       => esc_html__( 'Post Number', 'blogun' ),
					'description' => esc_html__( 'Set the number of visible posts.', 'blogun' ),
					'min'         => 1,
					'max'         => 500,
					'step'        => 1,
					'unit'        => '',
					'required'    => array(
						array(
							'control'  => 'blogun_enable_ticker',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_posts',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_ticker_type',
							'value'    => 'hover-slider',
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Ticker();
