<?php
/**
 * Blogun Sticky Header Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Sticky_Header' ) ) :
	/**
	 * Blogun Sticky Header section in Customizer.
	 */
	class Blogun_Customizer_Sticky_Header {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Sticky Header Section.
			$options['section']['blogun_section_sticky_header'] = array(
				'title'    => esc_html__( 'Sticky Header', 'blogun' ),
				'panel'    => 'blogun_panel_header',
				'priority' => 80,
			);

			// Enable Transparent Header.
			$options['setting']['blogun_sticky_header'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'label'   => esc_html__( 'Enable Sticky Header', 'blogun' ),
					'section' => 'blogun_section_sticky_header',
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Sticky_Header();
