<?php
/**
 * Blogun Blog - Single Post section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Single_Post' ) ) :
	/**
	 * Blogun Blog - Single Post section in Customizer.
	 */
	class Blogun_Customizer_Single_Post {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_blog_single_post'] = array(
				'title'    => esc_html__( 'Single Post', 'blogun' ),
				'panel'    => 'blogun_panel_blog',
				'priority' => 20,
			);

			// Single post layout.
			$options['setting']['blogun_single_post_layout_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Layout', 'blogun' ),
					'section' => 'blogun_section_blog_single_post',
				),
			);

			// Content Layout.
			$options['setting']['blogun_single_title_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Title Position', 'blogun' ),
					'description' => esc_html__( 'Select title position for single post pages.', 'blogun' ),
					'section'     => 'blogun_section_blog_single_post',
					'choices'     => array(
						'in-content'     => esc_html__( 'In Content', 'blogun' ),
						'in-page-header' => esc_html__( 'In Page Header', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_single_post_layout_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Spacing.
			$options['setting']['blogun_single_title_spacing'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'        => 'blogun-spacing',
					'label'       => esc_html__( 'Title Spacing', 'blogun' ),
					'description' => esc_html__( 'Specify title top and bottom padding.', 'blogun' ),
					'section'     => 'blogun_section_blog_single_post',
					'choices'     => array(
						'top'    => esc_html__( 'Top', 'blogun' ),
						'bottom' => esc_html__( 'Bottom', 'blogun' ),
					),
					'responsive'  => true,
					'unit'        => array(
						'px',
					),
					'required'    => array(
						array(
							'control'  => 'blogun_single_post_layout_heading',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_single_title_position',
							'value'    => 'in-page-header',
							'operator' => '==',
						),
					),
				),
			);

			// Single post elements.
			$options['setting']['blogun_single_post_elements_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Post Elements', 'blogun' ),
					'section' => 'blogun_section_blog_single_post',
				),
			);

			$options['setting']['blogun_single_post_elements'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_blog_single_post',
					'label'       => esc_html__( 'Post Elements', 'blogun' ),
					'description' => esc_html__( 'Set visibility of post elements.', 'blogun' ),
					'sortable'    => false,
					'choices'     => array(
						'thumb'          => esc_html__( 'Featured Image', 'blogun' ),
						'category'       => esc_html__( 'Post Categories', 'blogun' ),
						'tags'           => esc_html__( 'Post Tags', 'blogun' ),
						'last-updated'   => esc_html__( 'Last Updated Date', 'blogun' ),
						'about-author'   => esc_html__( 'About Author Box', 'blogun' ),
						'prev-next-post' => esc_html__( 'Next/Prev Post Links', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_single_post_elements_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Meta/Post Details Layout.
			$options['setting']['blogun_single_post_meta_elements'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'label'       => esc_html__( 'Post Meta', 'blogun' ),
					'description' => esc_html__( 'Set order and visibility for post meta details.', 'blogun' ),
					'section'     => 'blogun_section_blog_single_post',
					'choices'     => array(
						'author'   => esc_html__( 'Author', 'blogun' ),
						'date'     => esc_html__( 'Publish Date', 'blogun' ),
						'comments' => esc_html__( 'Comments', 'blogun' ),
						'category' => esc_html__( 'Categories', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_single_post_elements_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Meta icons.
			$options['setting']['blogun_single_entry_meta_icons'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-toggle',
					'section'  => 'blogun_section_blog_single_post',
					'label'    => esc_html__( 'Show avatar and icons in post meta', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_single_post_elements_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Toggle Comments.
			$options['setting']['blogun_single_toggle_comments'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Show Toggle Comments', 'blogun' ),
					'description' => esc_html__( 'Hide comments and comment form behind a toggle button. ', 'blogun' ),
					'section'     => 'blogun_section_blog_single_post',
					'required'    => array(
						array(
							'control'  => 'blogun_single_post_elements_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Single_Post();
