<?php
/**
 * Blogun Sidebar section in Customizer.
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Sidebar' ) ) :

	/**
	 * Blogun Sidebar section in Customizer.
	 */
	class Blogun_Customizer_Sidebar {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_sidebar'] = array(
				'title'    => esc_html__( 'Sidebar', 'blogun' ),
				'priority' => 4,
			);

			// Default sidebar position.
			$options['setting']['blogun_sidebar_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'section'     => 'blogun_section_sidebar',
					'label'       => esc_html__( 'Default Position', 'blogun' ),
					'description' => esc_html__( 'Choose default sidebar position layout. You can change this setting per page via metabox settings.', 'blogun' ),
					'choices'     => array(
						'no-sidebar'    => esc_html__( 'No Sidebar', 'blogun' ),
						'left-sidebar'  => esc_html__( 'Left Sidebar', 'blogun' ),
						'right-sidebar' => esc_html__( 'Right Sidebar', 'blogun' ),
					),
				),
			);

			// Single post sidebar position.
			$options['setting']['blogun_single_post_sidebar_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Single Post', 'blogun' ),
					'description' => esc_html__( 'Choose default sidebar position layout for single posts. You can change this setting per post via metabox settings.', 'blogun' ),
					'section'     => 'blogun_section_sidebar',
					'choices'     => array(
						'default'       => esc_html__( 'Default', 'blogun' ),
						'no-sidebar'    => esc_html__( 'No Sidebar', 'blogun' ),
						'left-sidebar'  => esc_html__( 'Left Sidebar', 'blogun' ),
						'right-sidebar' => esc_html__( 'Right Sidebar', 'blogun' ),
					),
				),
			);

			// Single page sidebar position.
			$options['setting']['blogun_single_page_sidebar_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Page', 'blogun' ),
					'description' => esc_html__( 'Choose default sidebar position layout for pages. You can change this setting per page via metabox settings.', 'blogun' ),
					'section'     => 'blogun_section_sidebar',
					'choices'     => array(
						'default'       => esc_html__( 'Default', 'blogun' ),
						'no-sidebar'    => esc_html__( 'No Sidebar', 'blogun' ),
						'left-sidebar'  => esc_html__( 'Left Sidebar', 'blogun' ),
						'right-sidebar' => esc_html__( 'Right Sidebar', 'blogun' ),
					),
				),
			);

			// Archive sidebar position.
			$options['setting']['blogun_archive_sidebar_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Archives & Search', 'blogun' ),
					'description' => esc_html__( 'Choose default sidebar position layout for archives and search results.', 'blogun' ),
					'section'     => 'blogun_section_sidebar',
					'choices'     => array(
						'default'       => esc_html__( 'Default', 'blogun' ),
						'no-sidebar'    => esc_html__( 'No Sidebar', 'blogun' ),
						'left-sidebar'  => esc_html__( 'Left Sidebar', 'blogun' ),
						'right-sidebar' => esc_html__( 'Right Sidebar', 'blogun' ),
					),
				),
			);

			// Sidebar options heading.
			$options['setting']['blogun_sidebar_options_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Options', 'blogun' ),
					'section' => 'blogun_section_sidebar',
				),
			);

			// Sidebar width.
			$options['setting']['blogun_sidebar_width'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_sidebar',
					'label'       => esc_html__( 'Sidebar Width', 'blogun' ),
					'description' => esc_html__( 'Change your sidebar width.', 'blogun' ),
					'min'         => 15,
					'max'         => 50,
					'step'        => 1,
					'unit'        => '%',
					'required'    => array(
						array(
							'control'  => 'blogun_sidebar_options_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Sticky sidebar.
			$options['setting']['blogun_sidebar_sticky'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'section'     => 'blogun_section_sidebar',
					'label'       => esc_html__( 'Sticky Sidebar', 'blogun' ),
					'description' => esc_html__( 'Stick sidebar when scrolling.', 'blogun' ),
					'choices'     => array(
						''        => esc_html__( 'Disable', 'blogun' ),
						'sidebar' => esc_html__( 'Stick first widget', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_sidebar_options_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;

new Blogun_Customizer_Sidebar();
