<?php
/**
 * Blogun Customizer sections and panels.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Sections' ) ) :
	/**
	 * Blogun Customizer sections and panels.
	 */
	class Blogun_Customizer_Sections {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom panels in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_panel' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_panel( $options ) {

			// General panel.
			$options['panel']['blogun_panel_general'] = array(
				'title'    => esc_html__( 'General Settings', 'blogun' ),
				'priority' => 1,
			);

			// Homapepage panel.
			$options['panel']['blogun_panel_homepage'] = array(
				'title'    => esc_html__( 'Homapage sections', 'blogun' ),
				'priority' => 3,
			);

			// Header panel.
			$options['panel']['blogun_panel_header'] = array(
				'title'    => esc_html__( 'Header', 'blogun' ),
				'priority' => 3,
			);

			// Footer panel.
			$options['panel']['blogun_panel_footer'] = array(
				'title'    => esc_html__( 'Footer', 'blogun' ),
				'priority' => 5,
			);

			// Blog settings.
			$options['panel']['blogun_panel_blog'] = array(
				'title'    => esc_html__( 'Blog', 'blogun' ),
				'priority' => 6,
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Sections();
