<?php
/**
 * Blogun PYML section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_PYML' ) ) :
	/**
	 * Blogun PYML section in Customizer.
	 */
	class Blogun_Customizer_PYML {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {
			// Posts You Might Like Section.
			$options['section']['blogun_section_pyml'] = array(
				'title'    => esc_html__( 'Posts You Might Like', 'blogun' ),
				'priority' => 3,
			);

			// Posts You Might Like enable.
			$options['setting']['blogun_enable_pyml'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'section' => 'blogun_section_pyml',
					'label'   => esc_html__( 'Enable Posts You Might Like Section', 'blogun' ),
				),
			);

			// Title.
			$options['setting']['blogun_pyml_title'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
				'control'           => array(
					'type'     => 'blogun-text',
					'section'  => 'blogun_section_pyml',
					'label'    => esc_html__( 'Title', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Posts You Might Like display on.
			$options['setting']['blogun_pyml_enable_on'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_no_sanitize',
				'control'           => array(
					'type'        => 'blogun-checkbox-group',
					'label'       => esc_html__( 'Enable On: ', 'blogun' ),
					'description' => esc_html__( 'Choose on which pages you want to enable Posts You Might Like. ', 'blogun' ),
					'section'     => 'blogun_section_pyml',
					'choices'     => array(
						'home'       => array(
							'title' => esc_html__( 'Home Page', 'blogun' ),
						),
						'posts_page' => array(
							'title' => esc_html__( 'Blog / Posts Page', 'blogun' ),
						),
						'archive'    => array(
							'title' => esc_html__( 'Archive Page', 'blogun' ),
						),
						'search'     => array(
							'title' => esc_html__( 'Search Page', 'blogun' ),
						),
						'post'       => array(
							'title' => esc_html__( 'Single Post', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// PYML heading.
			$options['setting']['blogun_pyml_style'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_pyml',
					'label'    => esc_html__( 'Style', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// PYML Elements.
			$options['setting']['blogun_pyml_elements'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_pyml',
					'label'       => esc_html__( 'Post Elements', 'blogun' ),
					'description' => esc_html__( 'Set order and visibility for post elements.', 'blogun' ),
					'sortable'    => false,
					'choices'     => array(
						'category' => esc_html__( 'Categories', 'blogun' ),
						'meta'     => esc_html__( 'Post Details', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_pyml_style',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#pyml',
					'render_callback'     => 'blogun_blog_pyml',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Post Settings heading.
			$options['setting']['blogun_pyml_posts'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_pyml',
					'label'    => esc_html__( 'Post Settings', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Post count.
			$options['setting']['blogun_pyml_post_number'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_pyml',
					'label'       => esc_html__( 'Post Number', 'blogun' ),
					'description' => esc_html__( 'Set the number of visible posts.', 'blogun' ),
					'min'         => 1,
					'max'         => 4,
					'step'        => 1,
					'unit'        => '',
					'required'    => array(
						array(
							'control'  => 'blogun_enable_pyml',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_pyml_posts',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#pyml',
					'render_callback'     => 'blogun_blog_pyml',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_PYML();
