<?php
/**
 * Blogun Pro Features section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Pro_Features' ) ) :
	/**
	 * Blogun PYML section in Customizer.
	 */
	class Blogun_Customizer_Pro_Features {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {
			// Pro features section
			$options['section']['blogun_section_blogun_pro'] = array(
				'title'    => esc_html__( 'View pro features', 'blogun' ),
				'priority' => 0,
			);

			$options['setting']['blogun_section_blogun_pro_features'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
				'control'           => array(
					'type'     => 'blogun-pro',
					'section'  => 'blogun_section_blogun_pro',
					// 'screenshot' => apply_filters( 'blogun_pro_theme_screenshot', esc_url( get_template_directory_uri() ) . '/assets/images/blogun_pro.png' ),
					'features' => apply_filters(
						'blogun_pro_theme_features',
						array(
							esc_html__( 'All starter sites included', 'blogun' ),
							esc_html__( 'Advance Header Options', 'blogun' ),
							esc_html__( 'Advance FrontPage Slider Layouts', 'blogun' ),
							esc_html__( 'Post Advance Featured', 'blogun' ),
							esc_html__( 'Meta Category Options', 'blogun' ),
							esc_html__( 'Site Layouts Options', 'blogun' ),
							esc_html__( 'Archive Layout Options', 'blogun' ),
							esc_html__( 'Sticky Sidebar Options', 'blogun' ),
							esc_html__( 'Advance Color Scheme', 'blogun' ),
							esc_html__( 'Buttons & Links color options', 'blogun' ),
							esc_html__( 'Author Widgets', 'blogun' ),
							esc_html__( 'Title Design Settings', 'blogun' ),
							esc_html__( 'Masonry Grid & Multi Post Options', 'blogun' ),
							esc_html__( 'Full Width Post/Page Options', 'blogun' ),
							esc_html__( 'Single Post/Page Layout Options', 'blogun' ),
							esc_html__( 'Single Post/Page Left/Right Sidebar', 'blogun' ),
							esc_html__( 'Footer Advance Featured', 'blogun' ),
							esc_html__( 'Footer Widgets Options', 'blogun' ),
							esc_html__( 'Live Container Manage Options', 'blogun' ),
							esc_html__( 'SEO Meta', 'blogun' ),
							esc_html__( 'AMP Compatibility', 'blogun' ),
							esc_html__( 'Coming Soon/Maintenance Mode Option', 'blogun' ),
							esc_html__( 'Regular Premium Updates', 'blogun' ),
							esc_html__( 'Quick Support', 'blogun' ),
							esc_html__( 'And much more...', 'blogun' ),
						)
					),
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_Pro_Features();
