<?php
/**
 * Blogun Page Title Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Page_Header' ) ) :
	/**
	 * Blogun Page Title Settings section in Customizer.
	 */
	class Blogun_Customizer_Page_Header {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Page Title Section.
			$options['section']['blogun_section_page_header'] = array(
				'title'    => esc_html__( 'Page Header', 'blogun' ),
				'panel'    => 'blogun_panel_header',
				'priority' => 60,
			);

			// Page Header enable.
			$options['setting']['blogun_page_header_enable'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'label'   => esc_html__( 'Enable Page Header', 'blogun' ),
					'section' => 'blogun_section_page_header',
				),
			);

			// Spacing.
			$options['setting']['blogun_page_header_spacing'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'        => 'blogun-spacing',
					'label'       => esc_html__( 'Page Title Spacing', 'blogun' ),
					'description' => esc_html__( 'Specify Page Title top and bottom padding.', 'blogun' ),
					'section'     => 'blogun_section_page_header',
					'choices'     => array(
						'top'    => esc_html__( 'Top', 'blogun' ),
						'bottom' => esc_html__( 'Bottom', 'blogun' ),
					),
					'responsive'  => true,
					'unit'        => array(
						'px',
					),
					'required'    => array(
						array(
							'control'  => 'blogun_page_header_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Page Header design options heading.
			$options['setting']['blogun_page_header_heading_design'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Design Options', 'blogun' ),
					'section'  => 'blogun_section_page_header',
					'required' => array(
						array(
							'control'  => 'blogun_page_header_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Page Header background design.
			$options['setting']['blogun_page_header_background'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Background', 'blogun' ),
					'section'  => 'blogun_section_page_header',
					'display'  => array(
						'background' => array(
							'color'    => esc_html__( 'Solid Color', 'blogun' ),
							'gradient' => esc_html__( 'Gradient', 'blogun' ),
							'image'    => esc_html__( 'Image', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_page_header_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_page_header_heading_design',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Page Header Text Color.
			$options['setting']['blogun_page_header_text_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Font Color', 'blogun' ),
					'section'  => 'blogun_section_page_header',
					'display'  => array(
						'color' => array(
							'text-color'       => esc_html__( 'Text Color', 'blogun' ),
							'link-color'       => esc_html__( 'Link Color', 'blogun' ),
							'link-hover-color' => esc_html__( 'Link Hover Color', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_page_header_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_page_header_heading_design',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Page_Header();
