<?php
/**
 * Blogun Misc section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Misc' ) ) :
	/**
	 * Blogun Misc section in Customizer.
	 */
	class Blogun_Customizer_Misc {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_misc'] = array(
				'title'    => esc_html__( 'Misc Settings', 'blogun' ),
				'panel'    => 'blogun_panel_general',
				'priority' => 60,
			);

			// Schema toggle.
			$options['setting']['blogun_enable_schema'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Schema Markup', 'blogun' ),
					'description' => esc_html__( 'Add structured data to your content.', 'blogun' ),
					'section'     => 'blogun_section_misc',
				),
			);

			// Custom form styles.
			$options['setting']['blogun_custom_input_style'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Custom Form Styles', 'blogun' ),
					'description' => esc_html__( 'Custom design for checkboxes and radio buttons.', 'blogun' ),
					'section'     => 'blogun_section_misc',
				),
			);

			// Scroll Top heading.
			$options['setting']['blogun_scroll_top_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Scroll Top Button', 'blogun' ),
					'section' => 'blogun_section_misc',
				),
			);

			// Enable/Disable Scroll Top.
			$options['setting']['blogun_enable_scroll_top'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Enable Scroll Top Button', 'blogun' ),
					'description' => esc_html__( 'A sticky button that allows users to easily return to the top of a page.', 'blogun' ),
					'section'     => 'blogun_section_misc',
					'required'    => array(
						array(
							'control'  => 'blogun_scroll_top_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Cursor Dot heading.
			$options['setting']['blogun_cursor_dot_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-heading',
					'label'   => esc_html__( 'Cursor Dot Effect', 'blogun' ),
					'section' => 'blogun_section_misc',
				),
			);

			// Enable/Disable Cursor Dot.
			$options['setting']['blogun_enable_cursor_dot'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Enable Cursor Dot', 'blogun' ),
					'description' => esc_html__( 'A cursor dot effect show on desktop size mode only with work on mouse.', 'blogun' ),
					'section'     => 'blogun_section_misc',
					'required'    => array(
						array(
							'control'  => 'blogun_cursor_dot_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Misc();
