<?php
/**
 * Blogun Main Header Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Main_Header' ) ) :
	/**
	 * Blogun Main Header section in Customizer.
	 */
	class Blogun_Customizer_Main_Header {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Main Header Section.
			$options['section']['blogun_section_main_header'] = array(
				'title'    => esc_html__( 'Main Header', 'blogun' ),
				'panel'    => 'blogun_panel_header',
				'priority' => 20,
			);

			// Header Layout.
			$options['setting']['blogun_header_layout'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-radio-image',
					'label'       => esc_html__( 'Header Layout', 'blogun' ),
					'description' => esc_html__( 'Pre-defined positions of header elements, such as logo and navigation.', 'blogun' ),
					'section'     => 'blogun_section_main_header',
					'priority'    => 5,
					'choices'     => array(
						'layout-4' => array(
							'image' => BLOGUN_THEME_URI . '/inc/customizer/assets/images/header-layout-4.svg',
							'title' => esc_html__( 'Header 1', 'blogun' ),
						),
					),
				),
			);

			// Header Ads Banner
			$options['setting']['blogun_header_ads_banner'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_url',
				'control'           => array(
					'class'           => 'WP_Customize_Image_Control',
					'mime_type'       => 'image',
					'label'           => esc_html__( 'Ads image', 'blogun' ),
					'description'     => esc_html__( 'Click “Add new image” to upload an image file from your computer. Your theme works best with an image with a banner size of 728 × 90 pixels. ', 'blogun' ),
					'section'         => 'blogun_section_main_header',
					'priority'        => 6,
					'active_callback' => function( $control ) {
						return 'layout-4' === $control->manager->get_setting( 'blogun_header_layout' )->value() ? true : false;},
				),
			);

			// Header Ads Banner URL
			$options['setting']['blogun_header_ads_banner_url'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_url_raw',
				'control'           => array(
					'type'            => 'url',
					'label'           => esc_html__( 'Ads url', 'blogun' ),
					'section'         => 'blogun_section_main_header',
					'priority'        => 7,
					'active_callback' => function( $control ) {
						return 'layout-4' === $control->manager->get_setting( 'blogun_header_layout' )->value() ? true : false;},
				),
			);

			// Header Ads Banner URL Target
			$options['setting']['blogun_header_ads_banner_url_target'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'            => 'blogun-select',
					'label'           => esc_html__( 'Open Ads link on', 'blogun' ),
					'section'         => 'blogun_section_main_header',
					'priority'        => 8,
					'choices'         => array(
						'_self'  => esc_html__( 'Open in same tab', 'blogun' ),
						'_blank' => esc_html__( 'Open in new tab', 'blogun' ),
					),
					'active_callback' => function( $control ) {
						return 'layout-4' === $control->manager->get_setting( 'blogun_header_layout' )->value() ? true : false;},
				),
			);

			// Header widgets heading.
			$options['setting']['blogun_header_heading_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-heading',
					'label'       => esc_html__( 'Header Widgets', 'blogun' ),
					'description' => esc_html__( 'Click the Add Widget button to add available widgets to your Header. Click the down arrow icon to expand widget options.', 'blogun' ),
					'section'     => 'blogun_section_main_header',
					'space'       => true,
				),
			);

			// Header widgets.
			$options['setting']['blogun_header_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_widget',
				'control'           => array(
					'type'       => 'blogun-widget',
					'label'      => esc_html__( 'Header Widgets', 'blogun' ),
					'section'    => 'blogun_section_main_header',
					'widgets'    => apply_filters(
						'blogun_main_header_widgets',
						array(
							'search'   => array(
								'max_uses' => 1,
							),
							'darkmode' => array(
								'max_uses' => 1,
							),
							'button'   => array(
								'max_uses' => 1,
							),
							'socials'  => array(
								'max_uses' => 1,								
								'styles'   => array(
									'minimal' => esc_html__( 'Minimal', 'blogun' ),
									'rounded' => esc_html__( 'Rounded', 'blogun' ),
									'minimal-fill' => esc_html__( 'Minimal Fill', 'blogun' ),
									'rounded-fill' => esc_html__( 'Rounded Fill', 'blogun' ),
								),
								'sizes'     => array(
									'small' => esc_html__( 'Small', 'blogun' ),
									'standard' => esc_html__( 'Standard', 'blogun' ),
									'large' => esc_html__( 'Large', 'blogun' ),
									'xlarge' => esc_html__( 'Extra Large', 'blogun' ),
								),
							),
						)
					),
					'locations'  => array(
						'left'  => esc_html__( 'Left', 'blogun' ),
						'right' => esc_html__( 'Right', 'blogun' ),
					),
					'visibility' => array(
						'all'                => esc_html__( 'Show on All Devices', 'blogun' ),
						'hide-mobile'        => esc_html__( 'Hide on Mobile', 'blogun' ),
						'hide-tablet'        => esc_html__( 'Hide on Tablet', 'blogun' ),
						'hide-mobile-tablet' => esc_html__( 'Hide on Mobile and Tablet', 'blogun' ),
					),
					'required'   => array(
						array(
							'control'  => 'blogun_header_heading_widgets',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#blogun-header',
					'render_callback'     => 'blogun_header_content_output',
					'container_inclusive' => false,
					'fallback_refresh'    => true,
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Main_Header();
