<?php
/**
 * Blogun Main Footer section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Main_Footer' ) ) :
	/**
	 * Blogun Main Footer section in Customizer.
	 */
	class Blogun_Customizer_Main_Footer {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_main_footer'] = array(
				'title'    => esc_html__( 'Main Footer', 'blogun' ),
				'panel'    => 'blogun_panel_footer',
				'priority' => 20,
			);

			// Enable Footer.
			$options['setting']['blogun_enable_footer'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'label'   => esc_html__( 'Enable Main Footer', 'blogun' ),
					'section' => 'blogun_section_main_footer',
				),
			);

			// Footer Layout.
			$options['setting']['blogun_footer_layout'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-radio-image',
					'label'       => esc_html__( 'Column Layout', 'blogun' ),
					'description' => esc_html__( 'Choose your site&rsquo;s footer column layout.', 'blogun' ),
					'section'     => 'blogun_section_main_footer',
					'choices'     => array(
						'layout-1' => array(
							'image' => BLOGUN_THEME_URI . '/inc/customizer/assets/images/footer-layout-1.svg',
							'title' => esc_html__( '1/4 + 1/4 + 1/4 + 1/4', 'blogun' ),
						),
						'layout-2' => array(
							'image' => BLOGUN_THEME_URI . '/inc/customizer/assets/images/footer-layout-2.svg',
							'title' => esc_html__( '1/3 + 1/3 + 1/3', 'blogun' ),
						),
						'layout-8' => array(
							'image' => BLOGUN_THEME_URI . '/inc/customizer/assets/images/footer-layout-8.svg',
							'title' => esc_html__( '1', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#blogun-footer-widgets',
					'render_callback'     => 'blogun_footer_widgets',
					'container_inclusive' => false,
					'fallback_refresh'    => true,
				),
			);

			// Center footer widgets..
			$options['setting']['blogun_footer_widgets_align_center'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-toggle',
					'label'    => esc_html__( 'Center Widget Content', 'blogun' ),
					'section'  => 'blogun_section_main_footer',
					'required' => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#blogun-footer-widgets',
					'render_callback'     => 'blogun_footer_widgets',
					'container_inclusive' => false,
					'fallback_refresh'    => true,
				),
			);

			// Footer Design Options heading.
			$options['setting']['blogun_footer_heading_design_options'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Design Options', 'blogun' ),
					'section'  => 'blogun_section_main_footer',
					'required' => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Footer Background.
			$options['setting']['blogun_footer_background'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Background', 'blogun' ),
					'section'  => 'blogun_section_main_footer',
					'display'  => array(
						'background' => array(
							'color'    => esc_html__( 'Solid Color', 'blogun' ),
							'gradient' => esc_html__( 'Gradient', 'blogun' ),
							'image'    => esc_html__( 'Image', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_footer_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Footer Text Color.
			$options['setting']['blogun_footer_text_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Font Color', 'blogun' ),
					'section'  => 'blogun_section_main_footer',
					'display'  => array(
						'color' => array(
							'text-color'         => esc_html__( 'Text Color', 'blogun' ),
							'link-color'         => esc_html__( 'Link Color', 'blogun' ),
							'link-hover-color'   => esc_html__( 'Link Hover Color', 'blogun' ),
							'widget-title-color' => esc_html__( 'Widget Title Color', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_footer_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Footer Border.
			$options['setting']['blogun_footer_border'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Border', 'blogun' ),
					'section'  => 'blogun_section_main_footer',
					'display'  => array(
						'border' => array(
							'style'     => esc_html__( 'Style', 'blogun' ),
							'color'     => esc_html__( 'Color', 'blogun' ),
							'width'     => esc_html__( 'Width (px)', 'blogun' ),
							'positions' => array(
								'top'    => esc_html__( 'Top', 'blogun' ),
								'bottom' => esc_html__( 'Bottom', 'blogun' ),
							),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_enable_footer',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_footer_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_Main_Footer();
