<?php
/**
 * Blogun Logo section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Logo' ) ) :
	/**
	 * Blogun Logo section in Customizer.
	 */
	class Blogun_Customizer_Logo {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Logo Retina.
			$options['setting']['blogun_logo_default_retina'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_background',
				'control'           => array(
					'type'        => 'blogun-background',
					'section'     => 'title_tagline',
					'label'       => esc_html__( 'Retina Logo', 'blogun' ),
					'description' => esc_html__( 'Upload exactly 2x the size of your default logo to make your logo crisp on HiDPI screens. This options is not required if logo above is in SVG format.', 'blogun' ),
					'priority'    => 20,
					'advanced'    => false,
					'strings'     => array(
						'select_image' => __( 'Select logo', 'blogun' ),
						'use_image'    => __( 'Select', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'custom_logo',
							'value'    => false,
							'operator' => '!=',
						),
					),
				),
				'partial'           => array(
					'selector'            => '.blogun-logo',
					'render_callback'     => 'blogun_logo',
					'container_inclusive' => false,
					'fallback_refresh'    => true,
				),
			);

			// Logo Max Height.
			$options['setting']['blogun_logo_max_height'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'        => 'blogun-range',
					'label'       => esc_html__( 'Logo Height', 'blogun' ),
					'description' => esc_html__( 'Maximum logo image height.', 'blogun' ),
					'section'     => 'title_tagline',
					'priority'    => 30,
					'min'         => 0,
					'max'         => 1000,
					'step'        => 10,
					'unit'        => 'px',
					'responsive'  => true,
					'required'    => array(
						array(
							'control'  => 'custom_logo',
							'value'    => false,
							'operator' => '!=',
						),
					),
				),
			);

			// Logo margin.
			$options['setting']['blogun_logo_margin'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'        => 'blogun-spacing',
					'label'       => esc_html__( 'Logo Margin', 'blogun' ),
					'description' => esc_html__( 'Specify spacing around logo. Negative values are allowed.', 'blogun' ),
					'section'     => 'title_tagline',
					'settings'    => 'blogun_logo_margin',
					'priority'    => 40,
					'choices'     => array(
						'top'    => esc_html__( 'Top', 'blogun' ),
						'right'  => esc_html__( 'Right', 'blogun' ),
						'bottom' => esc_html__( 'Bottom', 'blogun' ),
						'left'   => esc_html__( 'Left', 'blogun' ),
					),
					'responsive'  => true,
					'unit'        => array(
						'px',
					),
				),
			);

			// Show tagline.
			$options['setting']['blogun_display_tagline'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-toggle',
					'label'    => esc_html__( 'Display Tagline', 'blogun' ),
					'section'  => 'title_tagline',
					'settings' => 'blogun_display_tagline',
					'priority' => 80,
				),
				'partial'           => array(
					'selector'            => '.blogun-logo',
					'render_callback'     => 'blogun_logo',
					'container_inclusive' => false,
					'fallback_refresh'    => true,
				),
			);

			// Site Identity heading.
			$options['setting']['blogun_logo_heading_site_identity'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Site Identity', 'blogun' ),
					'section'  => 'title_tagline',
					'settings' => 'blogun_logo_heading_site_identity',
					'priority' => 50,
					'toggle'   => false,
				),
			);

			// Logo typography heading.
			$options['setting']['blogun_typography_logo_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Typography', 'blogun' ),
					'section'  => 'title_tagline',
					'priority' => 100,
					'required' => array(
						array(
							'control'  => 'custom_logo',
							'value'    => false,
							'operator' => '==',
						),
					),
				),
			);

			// Site title font size.
			$options['setting']['blogun_logo_text_font_size'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'       => 'blogun-range',
					'label'      => esc_html__( 'Site Title Font Size', 'blogun' ),
					'section'    => 'title_tagline',
					'priority'   => 100,
					'min'        => 8,
					'max'        => 30,
					'step'       => 1,
					'responsive' => true,
					'unit'       => array(
						array(
							'id'   => 'px',
							'name' => 'px',
							'min'  => 8,
							'max'  => 90,
							'step' => 1,
						),
						array(
							'id'   => 'em',
							'name' => 'em',
							'min'  => 0.5,
							'max'  => 5,
							'step' => 0.01,
						),
						array(
							'id'   => 'rem',
							'name' => 'rem',
							'min'  => 0.5,
							'max'  => 5,
							'step' => 0.01,
						),
					),
					'required'   => array(
						array(
							'control'  => 'custom_logo',
							'value'    => false,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_typography_logo_heading',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Logo();
