<?php
/**
 * Blogun Layout section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Layout' ) ) :
	/**
	 * Blogun Layout section in Customizer.
	 */
	class Blogun_Customizer_Layout {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_layout_section'] = array(
				'title'    => esc_html__( 'Layout', 'blogun' ),
				'panel'    => 'blogun_panel_general',
				'priority' => 10,
			);

			// Site layout.
			$options['setting']['blogun_site_layout'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'section'     => 'blogun_layout_section',
					'label'       => esc_html__( 'Site Layout', 'blogun' ),
					'description' => esc_html__( 'Choose your site&rsquo;s main layout.', 'blogun' ),
					'choices'     => array(
						'fw-contained' => esc_html__( 'Full Width: Contained', 'blogun' ),
						'fw-stretched' => esc_html__( 'Full Width: Stretched', 'blogun' ),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Layout();
