<?php
/**
 * Blogun Hero Section Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Hero' ) ) :
	/**
	 * Blogun Page Title Settings section in Customizer.
	 */
	class Blogun_Customizer_Hero {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Hero Section.
			$options['section']['blogun_section_hero'] = array(
				'title'    => esc_html__( 'Hero', 'blogun' ),
				'priority' => 3,
			);

			// Hero enable.
			$options['setting']['blogun_enable_hero'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'section' => 'blogun_section_hero',
					'label'   => esc_html__( 'Enable Hero Section', 'blogun' ),
				),
			);

			// Hero display on.
			$options['setting']['blogun_hero_enable_on'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_no_sanitize',
				'control'           => array(
					'type'        => 'blogun-checkbox-group',
					'label'       => esc_html__( 'Enable On: ', 'blogun' ),
					'description' => esc_html__( 'Choose on which pages you want to enable Hero. ', 'blogun' ),
					'section'     => 'blogun_section_hero',
					'choices'     => array(
						'home'       => array(
							'title' => esc_html__( 'Home Page', 'blogun' ),
						),
						'posts_page' => array(
							'title' => esc_html__( 'Blog / Posts Page', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Hover Slider heading.
			$options['setting']['blogun_hero_hover_slider'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_hero',
					'label'    => esc_html__( 'Style', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Hover Slider height.
			$options['setting']['blogun_hero_hover_slider_height'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_hero',
					'label'       => esc_html__( 'Height', 'blogun' ),
					'description' => esc_html__( 'Set the height of the container.', 'blogun' ),
					'min'         => 350,
					'max'         => 1000,
					'step'        => 1,
					'unit'        => 'px',
					'required'    => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_hero_hover_slider',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Hover Slider Elements.
			$options['setting']['blogun_hero_hover_slider_elements'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_hero',
					'label'       => esc_html__( 'Post Elements', 'blogun' ),
					'description' => esc_html__( 'Set order and visibility for post elements.', 'blogun' ),
					'sortable'    => false,
					'choices'     => array(
						'category'  => esc_html__( 'Categories', 'blogun' ),
						'meta'      => esc_html__( 'Post Details', 'blogun' ),
						'read_more' => esc_html__( 'Continue Reading', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_hero_hover_slider',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#hero',
					'render_callback'     => 'blogun_blog_hero',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Post Settings heading.
			$options['setting']['blogun_hero_hover_slider_posts'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_hero',
					'label'    => esc_html__( 'Post Settings', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Post count.
			$options['setting']['blogun_hero_hover_slider_post_number'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_hero',
					'label'       => esc_html__( 'Post Number', 'blogun' ),
					'description' => esc_html__( 'Set the number of visible posts.', 'blogun' ),
					'min'         => 1,
					'max'         => 2,
					'step'        => 1,
					'unit'        => '',
					'required'    => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_hero_hover_slider_posts',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#hero',
					'render_callback'     => 'blogun_blog_hero',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Post category.
			$options['setting']['blogun_hero_hover_slider_category'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'section'     => 'blogun_section_hero',
					'label'       => esc_html__( 'Category', 'blogun' ),
					'description' => esc_html__( 'Display posts from selected category only. Leave empty to include all.', 'blogun' ),
					'is_select2'  => true,
					'data_source' => 'category',
					'multiple'    => true,
					'required'    => array(
						array(
							'control'  => 'blogun_enable_hero',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_hero_hover_slider_posts',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Hero();
