<?php
/**
 * Blogun Copyright Bar section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Copyright_Settings' ) ) :
	/**
	 * Blogun Copyright Bar section in Customizer.
	 */
	class Blogun_Customizer_Copyright_Settings {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			// Registers our custom options in Customizer.
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_copyright_bar'] = array(
				'title'    => esc_html__( 'Copyright Bar', 'blogun' ),
				'priority' => 30,
				'panel'    => 'blogun_panel_footer',
			);

			// Enable Copyright Bar.
			$options['setting']['blogun_enable_copyright'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'label'   => esc_html__( 'Enable Copyright Bar', 'blogun' ),
					'section' => 'blogun_section_copyright_bar',
				),
			);

			// Copyright Layout.
			$options['setting']['blogun_copyright_layout'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-radio-image',
					'section'     => 'blogun_section_copyright_bar',
					'label'       => esc_html__( 'Copyright Layout', 'blogun' ),
					'description' => esc_html__( 'Choose your site&rsquo;s copyright widgets layout.', 'blogun' ),
					'choices'     => array(
						'layout-1' => array(
							'image' => BLOGUN_THEME_URI . '/inc/customizer/assets/images/copyright-layout-1.svg',
							'title' => esc_html__( 'Centered', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Copyright widgets heading.
			$options['setting']['blogun_copyright_heading_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-heading',
					'section'     => 'blogun_section_copyright_bar',
					'label'       => esc_html__( 'Copyright Bar Widgets', 'blogun' ),
					'description' => esc_html__( 'Click the Add Widget button to add available widgets to your Copyright Bar.', 'blogun' ),
					'required'    => array(
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Copyright widgets.
			$options['setting']['blogun_copyright_widgets'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_widget',
				'control'           => array(
					'type'       => 'blogun-widget',
					'section'    => 'blogun_section_copyright_bar',
					'label'      => esc_html__( 'Copyright Bar Widgets', 'blogun' ),
					'widgets'    => array(
						'text' => array(
							'max_uses' => 1,
						),
						'nav'  => array(
							'menu_location' => apply_filters( 'blogun_footer_menu_location', 'blogun-footer' ),
							'max_uses'      => 1,
						),
					),
					'locations'  => array(
						'start' => esc_html__( 'Start', 'blogun' ),
						'end'   => esc_html__( 'End', 'blogun' ),
					),
					'visibility' => array(
						'all'                => esc_html__( 'Show on All Devices', 'blogun' ),
						'hide-mobile'        => esc_html__( 'Hide on Mobile', 'blogun' ),
						'hide-tablet'        => esc_html__( 'Hide on Tablet', 'blogun' ),
						'hide-mobile-tablet' => esc_html__( 'Hide on Mobile and Tablet', 'blogun' ),
					),
					'required'   => array(
						array(
							'control'  => 'blogun_copyright_heading_widgets',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
				'partial'           => array(
					'selector'            => '#blogun-copyright',
					'render_callback'     => 'blogun_copyright_bar_output',
					'container_inclusive' => true,
					'fallback_refresh'    => true,
				),
			);

			// Copyright design options heading.
			$options['setting']['blogun_copyright_heading_design_options'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'section'  => 'blogun_section_copyright_bar',
					'label'    => esc_html__( 'Design Options', 'blogun' ),
					'required' => array(
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Copyright Background.
			$options['setting']['blogun_copyright_background'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'section'  => 'blogun_section_copyright_bar',
					'label'    => esc_html__( 'Background', 'blogun' ),
					'space'    => true,
					'display'  => array(
						'background' => array(
							'color'    => esc_html__( 'Solid Color', 'blogun' ),
							'gradient' => esc_html__( 'Gradient', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_copyright_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Copyright Text Color.
			$options['setting']['blogun_copyright_text_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'        => 'blogun-design-options',
					'section'     => 'blogun_section_copyright_bar',
					'label'       => esc_html__( 'Font Color', 'blogun' ),
					'description' => '',
					'space'       => true,
					'display'     => array(
						'color' => array(
							'text-color'       => esc_html__( 'Text Color', 'blogun' ),
							'link-color'       => esc_html__( 'Link Color', 'blogun' ),
							'link-hover-color' => esc_html__( 'Link Hover Color', 'blogun' ),
						),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_copyright_heading_design_options',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_enable_copyright',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_Copyright_Settings();
