<?php
/**
 * Blogun Base Colors section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Colors' ) ) :
	/**
	 * Blogun Colors section in Customizer.
	 */
	class Blogun_Customizer_Colors {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_colors'] = array(
				'title'    => esc_html__( 'Base Colors', 'blogun' ),
				'panel'    => 'blogun_panel_general',
				'priority' => 20,
			);

			// Accent color.
			$options['setting']['blogun_accent_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_color',
				'control'           => array(
					'type'        => 'blogun-color',
					'label'       => esc_html__( 'Accent Color', 'blogun' ),
					'description' => esc_html__( 'The accent color is used subtly throughout your site, to call attention to key elements.', 'blogun' ),
					'section'     => 'blogun_section_colors',
					'priority'    => 10,
					'opacity'     => false,
				),
			);

			// Dark mode
			$options['setting']['blogun_dark_mode'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Dark mode', 'blogun' ),
					'description' => esc_html__( 'Enable dark mode.', 'blogun' ),
					'section'     => 'blogun_section_colors',
					'priority'    => 11,
				),
			);

			// Body background heading.
			$options['setting']['blogun_body_background_heading'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'priority' => 40,
					'label'    => esc_html__( 'Body Background', 'blogun' ),
					'section'  => 'blogun_section_colors',
					'toggle'   => false,
				),
			);

			return $options;
		}

	}
endif;
new Blogun_Customizer_Colors();
