<?php
/**
 * Buttons section in Customizer » General Settings.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Buttons' ) ) :
	/**
	 * Buttons section in Customizer » General Settings.
	 */
	class Blogun_Customizer_Buttons {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			$theme = wp_get_theme();
			// Upsell section
			$options['section']['blogun_section_upsell_button'] = array(
				'class'    => 'Blogun_Customizer_Control_Section_Pro',
				'title'    => esc_html__( 'Need more features?', 'blogun' ),
				'pro_url'  => sprintf( esc_url_raw( 'https://peregrine-themes.com/%s' ), strtolower( $theme->name ) ),
				'pro_text' => esc_html__( 'Upgrade to pro', 'blogun' ),
				'priority' => 60,
			);

			$options['setting']['blogun_section_upsell_heading'] = array(
				'control' => array(
					'type'    => 'hidden',
					'section' => 'blogun_section_upsell_button',
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Buttons();
