<?php
/**
 * Blogun Breadcrumbs Settings section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Breadcrumbs' ) ) :
	/**
	 * Blogun Breadcrumbs Settings section in Customizer.
	 */
	class Blogun_Customizer_Breadcrumbs {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Main Navigation Section.
			$options['section']['blogun_section_breadcrumbs'] = array(
				'title'    => esc_html__( 'Breadcrumbs', 'blogun' ),
				'panel'    => 'blogun_panel_header',
				'priority' => 70,
			);

			// Breadcrumbs.
			$options['setting']['blogun_breadcrumbs_enable'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'label'   => esc_html__( 'Enable Breadcrumbs', 'blogun' ),
					'section' => 'blogun_section_breadcrumbs',
				),
			);

			// Hide breadcrumbs on.
			$options['setting']['blogun_breadcrumbs_hide_on'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_no_sanitize',
				'control'           => array(
					'type'        => 'blogun-checkbox-group',
					'label'       => esc_html__( 'Disable On: ', 'blogun' ),
					'description' => esc_html__( 'Choose on which pages you want to disable breadcrumbs. ', 'blogun' ),
					'section'     => 'blogun_section_breadcrumbs',
					'choices'     => blogun_get_display_choices(),
					'required'    => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Position.
			$options['setting']['blogun_breadcrumbs_position'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'     => 'blogun-select',
					'label'    => esc_html__( 'Position', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'choices'  => array(
						'in-page-header' => esc_html__( 'In Page Header', 'blogun' ),
						'below-header'   => esc_html__( 'Below Header (Separate Container)', 'blogun' ),
					),
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Alignment.
			$options['setting']['blogun_breadcrumbs_alignment'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'     => 'blogun-alignment',
					'label'    => esc_html__( 'Alignment', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'choices'  => 'horizontal',
					'icons'    => array(
						'left'   => 'dashicons dashicons-editor-alignleft',
						'center' => 'dashicons dashicons-editor-aligncenter',
						'right'  => 'dashicons dashicons-editor-alignright',
					),
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_position',
							'value'    => 'below-header',
							'operator' => '==',
						),
					),
				),
			);

			// Spacing.
			$options['setting']['blogun_breadcrumbs_spacing'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_responsive',
				'control'           => array(
					'type'        => 'blogun-spacing',
					'label'       => esc_html__( 'Spacing', 'blogun' ),
					'description' => esc_html__( 'Specify top and bottom padding.', 'blogun' ),
					'section'     => 'blogun_section_breadcrumbs',
					'choices'     => array(
						'top'    => esc_html__( 'Top', 'blogun' ),
						'bottom' => esc_html__( 'Bottom', 'blogun' ),
					),
					'responsive'  => true,
					'unit'        => array(
						'px',
					),
					'required'    => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
					),
				),
			);

			// Design options heading.
			$options['setting']['blogun_breadcrumbs_heading_design'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-heading',
					'label'    => esc_html__( 'Design Options', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_position',
							'value'    => 'below-header',
							'operator' => '==',
						),
					),
				),
			);

			// Background design.
			$options['setting']['blogun_breadcrumbs_background'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Background', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'display'  => array(
						'background' => array(
							'color'    => esc_html__( 'Solid Color', 'blogun' ),
							'gradient' => esc_html__( 'Gradient', 'blogun' ),
							'image'    => esc_html__( 'Image', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_heading_design',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_position',
							'value'    => 'below-header',
							'operator' => '==',
						),
					),
				),
			);

			// Text Color.
			$options['setting']['blogun_breadcrumbs_text_color'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Font Color', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'display'  => array(
						'color' => array(
							'text-color'       => esc_html__( 'Text Color', 'blogun' ),
							'link-color'       => esc_html__( 'Link Color', 'blogun' ),
							'link-hover-color' => esc_html__( 'Link Hover Color', 'blogun' ),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_heading_design',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_position',
							'value'    => 'below-header',
							'operator' => '==',
						),
					),
				),
			);

			// Border.
			$options['setting']['blogun_breadcrumbs_border'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_design_options',
				'control'           => array(
					'type'     => 'blogun-design-options',
					'label'    => esc_html__( 'Border', 'blogun' ),
					'section'  => 'blogun_section_breadcrumbs',
					'display'  => array(
						'border' => array(
							'style'     => esc_html__( 'Style', 'blogun' ),
							'color'     => esc_html__( 'Color', 'blogun' ),
							'width'     => esc_html__( 'Width (px)', 'blogun' ),
							'positions' => array(
								'top'    => esc_html__( 'Top', 'blogun' ),
								'bottom' => esc_html__( 'Bottom', 'blogun' ),
							),
						),
					),
					'required' => array(
						array(
							'control'  => 'blogun_breadcrumbs_enable',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_heading_design',
							'value'    => true,
							'operator' => '==',
						),
						array(
							'control'  => 'blogun_breadcrumbs_position',
							'value'    => 'below-header',
							'operator' => '==',
						),
					),
				),
			);

			return $options;
		}
	}
endif;
new Blogun_Customizer_Breadcrumbs();
