<?php
/**
 * Blogun Blog » Blog Page / Archive section in Customizer.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Customizer_Blog_Page' ) ) :
	/**
	 * Blogun Blog » Blog Page / Archive section in Customizer.
	 */
	class Blogun_Customizer_Blog_Page {

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			/**
			 * Registers our custom options in Customizer.
			 */
			add_filter( 'blogun_customizer_options', array( $this, 'register_options' ) );
		}

		/**
		 * Registers our custom options in Customizer.
		 *
		 * @since 1.0.0
		 * @param array $options Array of customizer options.
		 */
		public function register_options( $options ) {

			// Section.
			$options['section']['blogun_section_blog_page'] = array(
				'title' => esc_html__( 'Blog Page / Archive', 'blogun' ),
				'panel' => 'blogun_panel_blog',
			);

			// Layout.
			$options['setting']['blogun_blog_layout'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Layout', 'blogun' ),
					'description' => esc_html__( 'Choose blog layout. This will affect blog layout on archives, search results and posts page.', 'blogun' ),
					'section'     => 'blogun_section_blog_page',
					'choices'     => array(
						'blog-masonry' => esc_html__( 'Masonry', 'blogun' ),
					),
				),
			);

			// Blog Layout Column.
			$options['setting']['blogun_blog_layout_column'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'        => 'blogun-select',
					'label'       => esc_html__( 'Layout Column', 'blogun' ),
					'description' => esc_html__( 'Choose blog layout Column. This will affect blog layout on archives, search results and posts page.', 'blogun' ),
					'section'     => 'blogun_section_blog_page',
					'choices'     => array(
						12 => esc_html__( 'Layout 1 Column', 'blogun' ),
						6  => esc_html__( 'Layout 1/2 Column', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_blog_layout',
							'value'    => 'blog-horizontal',
							'operator' => '!=',
						),
					),
				),
			);

			$_image_sizes = blogun_get_image_sizes();
			$size_choices = array();

			if ( ! empty( $_image_sizes ) ) {
				foreach ( $_image_sizes as $key => $value ) {
					$name = ucwords( str_replace( array( '-', '_' ), ' ', $key ) );

					$size_choices[ $key ] = $name;

					if ( $value['width'] || $value['height'] ) {
						$size_choices[ $key ] .= ' (' . $value['width'] . 'x' . $value['height'] . ')';
					}
				}
			}

			// Featured Image Size.
			$options['setting']['blogun_blog_image_size'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'    => 'blogun-select',
					'label'   => esc_html__( 'Featured Image Size', 'blogun' ),
					'section' => 'blogun_section_blog_page',
					'choices' => $size_choices,
				),
			);

			// Post Elements.
			$options['setting']['blogun_blog_entry_elements'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_blog_page',
					'label'       => esc_html__( 'Post Elements', 'blogun' ),
					'description' => esc_html__( 'Set order and visibility for post elements.', 'blogun' ),
					'choices'     => array(
						'summary'        => esc_html__( 'Summary', 'blogun' ),
						'header'         => esc_html__( 'Title', 'blogun' ),
						'meta'           => esc_html__( 'Post Meta', 'blogun' ),
						'thumbnail'      => esc_html__( 'Featured Image', 'blogun' ),
						'summary-footer' => esc_html__( 'Read More', 'blogun' ),
					),
					'required'    => array(
						array(
							'control'  => 'blogun_blog_layout',
							'value'    => 'blog-horizontal',
							'operator' => '!=',
						),
					),
				),
			);

			// Meta/Post Details Layout.
			$options['setting']['blogun_blog_entry_meta_elements'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_sortable',
				'control'           => array(
					'type'        => 'blogun-sortable',
					'section'     => 'blogun_section_blog_page',
					'label'       => esc_html__( 'Post Meta', 'blogun' ),
					'description' => esc_html__( 'Set order and visibility for post meta details.', 'blogun' ),
					'choices'     => array(
						'author'   => esc_html__( 'Author', 'blogun' ),
						'date'     => esc_html__( 'Publish Date', 'blogun' ),
						'comments' => esc_html__( 'Comments', 'blogun' ),
						'category' => esc_html__( 'Categories', 'blogun' ),
						'tag'      => esc_html__( 'Tags', 'blogun' ),
					),
				),
			);

			// Post Categories.
			$options['setting']['blogun_blog_horizontal_post_categories'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'        => 'blogun-toggle',
					'label'       => esc_html__( 'Show Post Categories', 'blogun' ),
					'description' => esc_html__( 'A list of categories the post belongs to. Displayed above post title.', 'blogun' ),
					'section'     => 'blogun_section_blog_page',
					'required'    => array(
						array(
							'control'  => 'blogun_blog_layout',
							'value'    => 'blog-horizontal',
							'operator' => '==',
						),
					),
				),
			);

			// Read More Button.
			$options['setting']['blogun_blog_horizontal_read_more'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'     => 'blogun-toggle',
					'label'    => esc_html__( 'Show Read More Button', 'blogun' ),
					'section'  => 'blogun_section_blog_page',
					'required' => array(
						array(
							'control'  => 'blogun_blog_layout',
							'value'    => 'blog-horizontal',
							'operator' => '==',
						),
					),
				),
			);

			// Meta Author image.
			$options['setting']['blogun_entry_meta_icons'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_toggle',
				'control'           => array(
					'type'    => 'blogun-toggle',
					'section' => 'blogun_section_blog_page',
					'label'   => esc_html__( 'Show avatar and icons in post meta', 'blogun' ),
				),
			);

			// Featured Image Position.
			$options['setting']['blogun_blog_image_position'] = array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'blogun_sanitize_select',
				'control'           => array(
					'type'     => 'blogun-select',
					'label'    => esc_html__( 'Featured Image Position', 'blogun' ),
					'section'  => 'blogun_section_blog_page',
					'choices'  => array(
						'left'  => esc_html__( 'Left', 'blogun' ),
						'right' => esc_html__( 'Right', 'blogun' ),
					),
					'required' => array(
						array(
							'control'  => 'blogun_blog_layout',
							'value'    => 'blog-horizontal',
							'operator' => '==',
						),
					),
				),
			);

			// Excerpt Length.
			$options['setting']['blogun_excerpt_length'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'blogun_sanitize_range',
				'control'           => array(
					'type'        => 'blogun-range',
					'section'     => 'blogun_section_blog_page',
					'label'       => esc_html__( 'Excerpt Length', 'blogun' ),
					'description' => esc_html__( 'Number of words displayed in the excerpt.', 'blogun' ),
					'min'         => 0,
					'max'         => 100,
					'step'        => 1,
					'unit'        => '',
					'responsive'  => false,
				),
			);

			// Excerpt more.
			$options['setting']['blogun_excerpt_more'] = array(
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
				'control'           => array(
					'type'        => 'blogun-text',
					'section'     => 'blogun_section_blog_page',
					'label'       => esc_html__( 'Excerpt More', 'blogun' ),
					'description' => esc_html__( 'What to append to excerpt if the text is cut.', 'blogun' ),
				),
			);

			return $options;
		}
	}
endif;

new Blogun_Customizer_Blog_Page();
