<?php
/**
 * Blogun Customizer helper functions.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Returns array of available widgets.
 *
 * @since 1.0.0
 * @return array, $widgets array of available widgets.
 */
function blogun_get_customizer_widgets() {

	$widgets = array(
		'text'     => 'Blogun_Customizer_Widget_Text',
		'nav'      => 'Blogun_Customizer_Widget_Nav',
		'socials'  => 'Blogun_Customizer_Widget_Socials',
		'search'   => 'Blogun_Customizer_Widget_Search',
		'darkmode' => 'Blogun_Customizer_Widget_Darkmode',
		'button'   => 'Blogun_Customizer_Widget_Button',
	);

	return apply_filters( 'blogun_customizer_widgets', $widgets );
}

/**
 * Get choices for "Hide on" customizer options.
 *
 * @since  1.0.0
 * @return array
 */
function blogun_get_display_choices() {

	// Default options.
	$return = array(
		'home'       => array(
			'title' => esc_html__( 'Home Page', 'blogun' ),
		),
		'posts_page' => array(
			'title' => esc_html__( 'Blog / Posts Page', 'blogun' ),
		),
		'search'     => array(
			'title' => esc_html__( 'Search', 'blogun' ),
		),
		'archive'    => array(
			'title' => esc_html__( 'Archive', 'blogun' ),
			'desc'  => esc_html__( 'Dynamic pages such as categories, tags, custom taxonomies...', 'blogun' ),
		),
		'post'       => array(
			'title' => esc_html__( 'Single Post', 'blogun' ),
		),
		'page'       => array(
			'title' => esc_html__( 'Single Page', 'blogun' ),
		),
	);

	// Get additionally registered post types.
	$post_types = get_post_types(
		array(
			'public'   => true,
			'_builtin' => false,
		),
		'objects'
	);

	if ( is_array( $post_types ) && ! empty( $post_types ) ) {
		foreach ( $post_types as $slug => $post_type ) {
			$return[ $slug ] = array(
				'title' => $post_type->label,
			);
		}
	}

	return apply_filters( 'blogun_display_choices', $return );
}

/**
 * Get device choices for "Display on" customizer options.
 *
 * @since  1.0.0
 * @return array
 */
function blogun_get_device_choices() {

	// Default options.
	$return = array(
		'desktop' => array(
			'title' => esc_html__( 'Hide On Desktop', 'blogun' ),
		),
		'tablet'  => array(
			'title' => esc_html__( 'Hide On Tablet', 'blogun' ),
		),
		'mobile'  => array(
			'title' => esc_html__( 'Hide On Mobile', 'blogun' ),
		),
	);

	return apply_filters( 'blogun_device_choices', $return );
}
