<?php

/**
 * Blogun Options Class.
 *
 * @package  Blogun
 * @author   Peregrine Themes
 * @since    1.0.0
 */

/**
 * Do not allow direct script access.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Blogun_Options' ) ) :

	/**
	 * Blogun Options Class.
	 */
	class Blogun_Options {

		/**
		 * Singleton instance of the class.
		 *
		 * @since 1.0.0
		 * @var object
		 */
		private static $instance;

		/**
		 * Options variable.
		 *
		 * @since 1.0.0
		 * @var mixed $options
		 */
		private static $options;

		/**
		 * Main Blogun_Options Instance.
		 *
		 * @since 1.0.0
		 * @return Blogun_Options
		 */
		public static function instance() {

			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Blogun_Options ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Primary class constructor.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			// Refresh options.
			add_action( 'after_setup_theme', array( $this, 'refresh' ) );
		}

		/**
		 * Set default option values.
		 *
		 * @since  1.0.0
		 * @return array Default values.
		 */
		public function get_defaults() {

			$defaults = array(

				/**
				 * General Settings.
				 */

				// Layout.
				'blogun_site_layout'                       => 'fw-contained',
				'blogun_container_width'                   => 1320,

				// Base Colors.
				'blogun_accent_color'                      => '#ff4c60',
				'blogun_dark_mode'                         => false,
				'blogun_content_text_color'                => '#131315',
				'blogun_headings_color'                    => '#131315',
				'blogun_content_link_hover_color'          => '#94979e',
				'blogun_body_background_heading'           => true,
				'blogun_content_background_heading'        => true,
				'blogun_boxed_content_background_color'    => '#FFFFFF',
				'blogun_scroll_top_visibility'             => 'all',

				// Base Typography.
				'blogun_html_base_font_size'               => array(
					'desktop' => 62.5,
					'tablet'  => 53,
					'mobile'  => 50,
				),
				'blogun_font_smoothing'                    => true,
				'blogun_typography_body_heading'           => false,
				'blogun_typography_headings_heading'       => false,
				'blogun_body_font'                         => blogun_typography_defaults(
					array(
						'font-family'         => 'Kumbh Sans',
						'font-weight'         => 400,
						'font-size-desktop'   => '1.7',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.75',
					)
				),
				'blogun_headings_font'                     => blogun_typography_defaults(
					array(
						'font-weight'     => 700,
						'font-style'      => 'normal',
						'text-transform'  => 'none',
						'text-decoration' => 'none',
					)
				),
				'blogun_h1_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 700,
						'font-size-desktop'   => '4',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.1',
					)
				),
				'blogun_h2_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 700,
						'font-size-desktop'   => '3.6',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.2',
					)
				),
				'blogun_h3_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 700,
						'font-size-desktop'   => '2.8',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.2',
					)
				),
				'blogun_h4_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 700,
						'font-size-desktop'   => '2.4',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.2',
					)
				),
				'blogun_h5_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 700,
						'font-size-desktop'   => '2',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.2',
					)
				),
				'blogun_h6_font'                           => blogun_typography_defaults(
					array(
						'font-weight'         => 600,
						'font-size-desktop'   => '1.8',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.72',
					)
				),
				'blogun_heading_em_font'                   => blogun_typography_defaults(
					array(
						'font-family' => 'Playfair Display',
						'font-weight' => 'inherit',
						'font-style'  => 'italic',
					)
				),
				'blogun_section_heading_style'             => '1',
				'blogun_footer_widget_title_font_size'     => array(
					'desktop' => 1.8,
					'unit'    => 'rem',
				),

				// Primary Button.
				'blogun_primary_button_heading'            => false,
				'blogun_primary_button_bg_color'           => '',
				'blogun_primary_button_hover_bg_color'     => '',
				'blogun_primary_button_text_color'         => '#fff',
				'blogun_primary_button_hover_text_color'   => '#fff',
				'blogun_primary_button_border_radius'      => array(
					'top-left'     => '',
					'top-right'    => '',
					'bottom-right' => '',
					'bottom-left'  => '',
					'unit'         => 'rem',
				),
				'blogun_primary_button_border_width'       => .1,
				'blogun_primary_button_border_color'       => '',
				'blogun_primary_button_hover_border_color' => '',
				'blogun_primary_button_typography'         => blogun_typography_defaults(
					array(
						'font-family'         => 'Plus Jakarta Sans',
						'font-weight'         => 500,
						'font-size-desktop'   => '1.8',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.6',
					)
				),

				// Secondary Button.
				'blogun_secondary_button_heading'          => false,
				'blogun_secondary_button_bg_color'         => '#1E293B',
				'blogun_secondary_button_hover_bg_color'   => '#3e4750',
				'blogun_secondary_button_text_color'       => '#FFFFFF',
				'blogun_secondary_button_hover_text_color' => '#FFFFFF',
				'blogun_secondary_button_border_radius'    => array(
					'top-left'     => '',
					'top-right'    => '',
					'bottom-right' => '',
					'bottom-left'  => '',
					'unit'         => 'rem',
				),
				'blogun_secondary_button_border_width'     => .1,
				'blogun_secondary_button_border_color'     => 'rgba(0, 0, 0, 0.12)',
				'blogun_secondary_button_hover_border_color' => 'rgba(0, 0, 0, 0.12)',
				'blogun_secondary_button_typography'       => blogun_typography_defaults(
					array(
						'font-family'         => 'Plus Jakarta Sans',
						'font-weight'         => 500,
						'font-size-desktop'   => '1.8',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.6',
					)
				),

				// Text button.
				'blogun_text_button_heading'               => false,
				'blogun_text_button_text_color'            => '#1E293B',
				'blogun_text_button_hover_text_color'      => '',
				'blogun_text_button_typography'            => blogun_typography_defaults(
					array(
						'font-family'         => 'Plus Jakarta Sans',
						'font-weight'         => 500,
						'font-size-desktop'   => '1.6',
						'font-size-unit'      => 'rem',
						'line-height-desktop' => '1.5',
					)
				),

				// Misc Settings.
				'blogun_enable_schema'                     => true,
				'blogun_custom_input_style'                => true,
				'blogun_preloader_heading'                 => false,
				'blogun_preloader'                         => false,
				'blogun_preloader_style'                   => '1',
				'blogun_preloader_visibility'              => 'all',
				'blogun_scroll_top_heading'                => false,
				'blogun_enable_scroll_top'                 => true,
				'blogun_enable_cursor_dot'                 => true,
				'blogun_parallax_footer'                   => false,

				/**
				 * Logos & Site Title.
				 */
				'blogun_logo_default_retina'               => '',
				'blogun_logo_max_height'                   => array(
					'desktop' => 45,
				),
				'blogun_logo_margin'                       => array(
					'desktop' => array(
						'top'    => 25,
						'right'  => 80,
						'bottom' => 25,
						'left'   => 0,
					),
					'tablet'  => array(
						'top'    => 25,
						'right'  => 1,
						'bottom' => 25,
						'left'   => 0,
					),
					'mobile'  => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'unit'    => 'px',
				),
				'blogun_display_tagline'                   => false,
				'blogun_logo_heading_site_identity'        => true,
				'blogun_typography_logo_heading'           => false,
				'blogun_logo_text_font_size'               => array(
					'desktop' => 3,
					'unit'    => 'rem',
				),

				/**
				 * Header.
				 */

				// Top Bar.
				'blogun_top_bar_enable'                    => true,
				'blogun_top_bar_container_width'           => 'content-width',
				'blogun_top_bar_visibility'                => 'hide-mobile',
				'blogun_top_bar_heading_widgets'           => true,
				'blogun_top_bar_widgets'                   => array(
					array(
						'classname' => 'blogun_customizer_widget_text',
						'type'      => 'text',
						'values'    => array(
							'content'    => esc_html__( 'This is a placeholder text widget in Top Bar section.', 'blogun' ),
							'location'   => 'left',
							'visibility' => 'all',
						),
					),
				),
				'blogun_top_bar_heading_design_options'    => false,
				'blogun_top_bar_background'                => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(
								'background-color' => '#131315',
							),
							'gradient' => array(),
						),
					)
				),
				'blogun_top_bar_text_color'                => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color'       => '#ffffff',
							'link-color'       => '#ffffff',
							'link-hover-color' => '#ff4c60',
						),
					)
				),
				'blogun_top_bar_border'                    => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-bottom-width' => '1',
							'border-style'        => 'solid',
							'border-color'        => 'rgba(0,0,0, .085)',
							'separator-color'     => '#cccccc',
						),
					)
				),

				// Main Header.
				'blogun_header_layout'                     => 'layout-4',

				'blogun_header_ads_banner'                 => get_template_directory_uri() . '/assets/images/header-promo.png',
				'blogun_header_ads_banner_url'             => '',
				'blogun_header_ads_banner_url_target'      => '_self',

				'blogun_header_container_width'            => 'content-width',
				'blogun_header_heading_widgets'            => true,
				'blogun_header_widgets'                    => array(
					array(
						'classname' => 'blogun_customizer_widget_socials',
						'type'      => 'socials',
						'values'    => array(
							'style'      => 'rounded',
							'size'       => 'standard',
							'location'   => 'left',
							'visibility' => 'hide-mobile-tablet',
						),
					),
					array(
						'classname' => 'blogun_customizer_widget_darkmode',
						'type'      => 'darkmode',
						'values'    => array(
							'location'   => 'right',
							'visibility' => 'hide-mobile-tablet',
						),
					),
					array(
						'classname' => 'blogun_customizer_widget_search',
						'type'      => 'search',
						'values'    => array(
							'location'   => 'right',
							'visibility' => 'hide-mobile-tablet',
						),
					),
					array(
						'classname' => 'blogun_customizer_widget_button',
						'type'      => 'button',
						'values'    => array(
							'text'       => 'Subscribe',
							'url'        => '#',
							'class'      => 'btn-small',
							'target'     => true,
							'location'   => 'right',
							'visibility' => 'hide-mobile-tablet',
						),
					),
				),
				'blogun_header_widgets_separator'          => 'none',
				'blogun_header_heading_design_options'     => false,
				'blogun_header_background'                 => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(
								'background-color' => '#FFFFFF',
							),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_header_border'                     => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-bottom-width' => 1,
							'border-color'        => 'rgba(0,0,0, .085)',
							'separator-color'     => '#cccccc',
						),
					)
				),
				'blogun_header_text_color'                 => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color' => '#66717f',
							'link-color' => '#131315',
						),
					)
				),

				// Transparent Header.
				'blogun_tsp_header'                        => false,
				'blogun_tsp_header_disable_on'             => array(
					'404',
					'posts_page',
					'archive',
					'search',
				),
				'blogun_tsp_logo_heading'                  => false,
				'blogun_tsp_logo'                          => '',
				'blogun_tsp_logo_retina'                   => '',
				'blogun_tsp_logo_max_height'               => array(
					'desktop' => 45,
				),
				'blogun_tsp_logo_margin'                   => array(
					'desktop' => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'tablet'  => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'mobile'  => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'unit'    => 'px',
				),
				'blogun_tsp_colors_heading'                => false,
				'blogun_tsp_header_background'             => blogun_design_options_defaults(
					array(
						'background' => array(
							'color' => array(),
						),
					)
				),
				'blogun_tsp_header_font_color'             => blogun_design_options_defaults(
					array(
						'color' => array(),
					)
				),
				'blogun_tsp_header_border'                 => blogun_design_options_defaults(
					array(
						'border' => array(),
					)
				),

				// Sticky Header.
				'blogun_sticky_header'                     => false,
				'blogun_sticky_header_hide_on'             => array( '' ),

				// Main Navigation.
				'blogun_main_nav_heading_animation'        => false,
				'blogun_main_nav_hover_animation'          => 'underline',
				'blogun_main_nav_heading_sub_menus'        => true,
				'blogun_main_nav_sub_indicators'           => true,
				'blogun_main_nav_heading_mobile_menu'      => false,
				'blogun_main_nav_mobile_breakpoint'        => 1024,
				'blogun_main_nav_mobile_label'             => '',
				'blogun_nav_design_options'                => false,
				'blogun_main_nav_background'               => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(
								'background-color' => '#FFFFFF',
							),
							'gradient' => array(),
						),
					)
				),
				'blogun_main_nav_border'                   => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-top-width'    => 1,
							'border-bottom-width' => 1,
							'border-style'        => 'solid',
							'border-color'        => 'rgba(0,0,0, .085)',
						),
					)
				),
				'blogun_main_nav_font_color'               => blogun_design_options_defaults(
					array(
						'color' => array(),
					)
				),
				'blogun_typography_main_nav_heading'       => false,
				'blogun_main_nav_font_size'                => array(
					'value' => 1.6,
					'unit'  => 'rem',
				),

				// Page Header.
				'blogun_page_header_enable'                => true,
				'blogun_page_header_alignment'             => 'left',
				'blogun_page_header_spacing'               => array(
					'desktop' => array(
						'top'    => 30,
						'bottom' => 30,
					),
					'tablet'  => array(
						'top'    => '',
						'bottom' => '',
					),
					'mobile'  => array(
						'top'    => '',
						'bottom' => '',
					),
					'unit'    => 'px',
				),
				'blogun_page_header_background'            => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array( 'background-color' => 'rgba(0,0,0,.025)' ),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_page_header_text_color'            => blogun_design_options_defaults(
					array(
						'color' => array(),
					)
				),
				'blogun_page_header_border'                => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-bottom-width' => 1,
							'border-style'        => 'solid',
							'border-color'        => 'rgba(0,0,0,.062)',
						),
					)
				),
				'blogun_typography_page_header'            => false,
				'blogun_page_header_font_size'             => array(
					'desktop' => 2.6,
					'unit'    => 'rem',
				),

				// Breadcrumbs.
				'blogun_breadcrumbs_enable'                => true,
				'blogun_breadcrumbs_hide_on'               => array( 'home' ),
				'blogun_breadcrumbs_position'              => 'in-page-header',
				'blogun_breadcrumbs_alignment'             => 'left',
				'blogun_breadcrumbs_spacing'               => array(
					'desktop' => array(
						'top'    => 15,
						'bottom' => 15,
					),
					'tablet'  => array(
						'top'    => '',
						'bottom' => '',
					),
					'mobile'  => array(
						'top'    => '',
						'bottom' => '',
					),
					'unit'    => 'px',
				),
				'blogun_breadcrumbs_heading_design'        => false,
				'blogun_breadcrumbs_background'            => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_breadcrumbs_text_color'            => blogun_design_options_defaults(
					array(
						'color' => array(),
					)
				),
				'blogun_breadcrumbs_border'                => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-top-width'    => 0,
							'border-bottom-width' => 0,
							'border-color'        => '',
							'border-style'        => 'solid',
						),
					)
				),

				/**
				 * Hero.
				 */
				'blogun_enable_hero'                       => true,
				'blogun_hero_type'                         => 'hover-slider',
				'blogun_hero_visibility'                   => 'all',
				'blogun_hero_enable_on'                    => array( 'home' ),
				'blogun_hero_hover_slider'                 => false,
				'blogun_hero_hover_slider_container'       => 'content-width',
				'blogun_hero_hover_slider_height'          => 500,
				'blogun_hero_hover_slider_overlay'         => '2',
				'blogun_hero_hover_slider_elements'        => array(
					'category'  => true,
					'meta'      => true,
					'read_more' => true,
				),
				'blogun_hero_hover_slider_posts'           => false,
				'blogun_hero_hover_slider_post_number'     => 2,
				'blogun_hero_hover_slider_category'        => array(),

				/**
				 * PYML
				 */
				'blogun_enable_pyml'                       => true,
				'blogun_pyml_title'                        => esc_html__( 'Post You Might Like', 'blogun' ),
				'blogun_pyml_visibility'                   => 'all',
				'blogun_pyml_enable_on'                    => array( 'home' ),
				'blogun_pyml_style'                        => false,
				'blogun_pyml_container'                    => 'content-width',
				'blogun_pyml_elements'                     => array(
					'category' => true,
					'meta'     => true,
				),
				'blogun_pyml_posts'                        => true,
				'blogun_pyml_post_number'                  => 4,
				'blogun_pyml_category'                     => array(),

				/**
				 * Ticker Slider
				 */
				'blogun_enable_ticker'                     => true,
				'blogun_ticker_title'                      => esc_html__( 'Headlines', 'blogun' ),
				'blogun_ticker_visibility'                 => 'all',
				'blogun_ticker_enable_on'                  => array( 'home' ),
				'blogun_ticker_style'                      => false,
				'blogun_ticker_container'                  => 'content-width',
				'blogun_ticker_elements'                   => array(
					'meta' => true,
				),
				'blogun_ticker_posts'                      => false,
				'blogun_ticker_post_number'                => 10,
				'blogun_ticker_category'                   => array(),

				/**
				 * Maintenance mode
				 */

				'blogun_enable_maintenance'                => false,
				'blogun_maintenance_text'                  => sprintf( '<h2 class="title">%1$s</h2><p class="description">%2$s</p>', esc_html__( 'Site Under construction.', 'blogun' ), esc_html__( 'Subscribe today and we will inform you once we go online.', 'blogun' ) ),
				'blogun_maintenance_background'            => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array( 'background-color' => 'rgba(0,0,0,.025)' ),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_maintenance_text_color'            => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color' => '#fff',
						),
					)
				),
				'blogun_maintenance_make_live'             => false,
				'blogun_maintenance_timezone'              => '',
				'blogun_enable_maintenance_form'           => false,
				'blogun_maintenance_form_shortcode'        => '',
				'blogun_enable_maintenance_social_media'   => false,
				'blogun_maintenance_style'                 => 1,

				/**
				 * Blog.
				 */

				// Blog Page / Archive.
				'blogun_blog_entry_elements'               => array(
					'thumbnail'      => true,
					'header'         => true,
					'meta'           => true,
					'summary'        => true,
					'summary-footer' => true,
				),
				'blogun_blog_entry_meta_elements'          => array(
					'author'   => true,
					'date'     => true,
					'category' => false,
					'tag'      => false,
					'comments' => false,
				),
				'blogun_entry_meta_icons'                  => true,
				'blogun_excerpt_length'                    => 30,
				'blogun_excerpt_more'                      => '&hellip;',
				'blogun_blog_layout'                       => 'blog-masonry',
				'blogun_blog_layout_column'                => 6,
				'blogun_blog_image_position'               => 'left',
				'blogun_blog_image_size'                   => 'large',
				'blogun_blog_card_border'                  => true,
				'blogun_blog_card_shadow'                  => true,
				'blogun_blog_horizontal_post_categories'   => true,
				'blogun_blog_horizontal_read_more'         => false,

				// Single Post.
				'blogun_single_post_layout_heading'        => false,
				'blogun_single_title_position'             => 'in-content',
				'blogun_single_title_alignment'            => 'left',
				'blogun_single_title_spacing'              => array(
					'desktop' => array(
						'top'    => 152,
						'bottom' => 100,
					),
					'tablet'  => array(
						'top'    => 90,
						'bottom' => 55,
					),
					'mobile'  => array(
						'top'    => '',
						'bottom' => '',
					),
					'unit'    => 'px',
				),
				'blogun_single_content_width'              => 'wide',
				'blogun_single_narrow_container_width'     => 700,
				'blogun_single_post_elements_heading'      => false,
				'blogun_single_post_meta_elements'         => array(
					'author'   => true,
					'date'     => true,
					'comments' => true,
					'category' => false,
				),
				'blogun_single_post_thumb'                 => true,
				'blogun_single_post_categories'            => true,
				'blogun_single_post_tags'                  => true,
				'blogun_single_last_updated'               => true,
				'blogun_single_about_author'               => true,
				'blogun_single_post_next_prev'             => true,
				'blogun_single_post_elements'              => array(
					'thumb'          => true,
					'category'       => true,
					'tags'           => true,
					'last-updated'   => true,
					'about-author'   => true,
					'prev-next-post' => true,
				),
				'blogun_single_toggle_comments'            => false,
				'blogun_single_entry_meta_icons'           => true,
				'blogun_typography_single_post_heading'    => false,
				'blogun_single_content_font_size'          => array(
					'desktop' => '1.6',
					'unit'    => 'rem',
				),

				/**
				 * Sidebar.
				 */

				'blogun_sidebar_position'                  => 'right-sidebar',
				'blogun_single_post_sidebar_position'      => 'no-sidebar',
				'blogun_single_page_sidebar_position'      => 'default',
				'blogun_archive_sidebar_position'          => 'default',
				'blogun_sidebar_options_heading'           => false,
				'blogun_sidebar_style'                     => '3',
				'blogun_sidebar_width'                     => 30,
				'blogun_sidebar_sticky'                    => 'sidebar',
				'blogun_sidebar_responsive_position'       => 'after-content',
				'blogun_typography_sidebar_heading'        => false,
				'blogun_sidebar_widget_title_font_size'    => array(
					'desktop' => 1.8,
					'unit'    => 'rem',
				),

				/**
				 * Footer.
				 */

				// Pre Footer.
				'blogun_pre_footer_cta'                    => true,
				'blogun_enable_pre_footer_cta'             => false,
				'blogun_pre_footer_cta_visibility'         => 'all',
				'blogun_pre_footer_cta_hide_on'            => array(),
				'blogun_pre_footer_cta_style'              => '1',
				'blogun_pre_footer_cta_text'               => wp_kses_post( __( 'This is an example of <em>Pre Footer</em> section in Blogun.', 'blogun' ) ),
				'blogun_pre_footer_cta_btn_text'           => wp_kses_post( __( 'Example Button', 'blogun' ) ),
				'blogun_pre_footer_cta_btn_url'            => '#',
				'blogun_pre_footer_cta_btn_new_tab'        => false,
				'blogun_pre_footer_cta_design_options'     => false,
				'blogun_pre_footer_cta_background'         => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_pre_footer_cta_border'             => blogun_design_options_defaults(
					array(
						'border' => array(),
					)
				),
				'blogun_pre_footer_cta_text_color'         => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color' => '#FFFFFF',
						),
					)
				),
				'blogun_pre_footer_cta_typography'         => false,
				'blogun_pre_footer_cta_font_size'          => array(
					'desktop' => 2.8,
					'unit'    => 'rem',
				),

				// Copyright.
				'blogun_enable_copyright'                  => true,
				'blogun_copyright_layout'                  => 'layout-1',
				'blogun_copyright_separator'               => 'contained-separator',
				'blogun_copyright_visibility'              => 'all',
				'blogun_copyright_heading_widgets'         => true,
				'blogun_copyright_widgets'                 => array(
					array(
						'classname' => 'blogun_customizer_widget_text',
						'type'      => 'text',
						'values'    => array(
							'content'    => esc_html__( 'Copyright {{the_year}} &mdash; {{site_title}}. All rights reserved. {{theme_link}}', 'blogun' ),
							'location'   => 'start',
							'visibility' => 'all',
						),
					),
				),
				'blogun_copyright_heading_design_options'  => false,
				'blogun_copyright_background'              => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(),
							'gradient' => array(),
						),
					)
				),
				'blogun_copyright_text_color'              => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color'       => '#131315',
							'link-color'       => '#131315',
							'link-hover-color' => '#000000',
						),
					)
				),

				// Main Footer.
				'blogun_enable_footer'                     => true,
				'blogun_footer_layout'                     => 'layout-2',
				'blogun_footer_widgets_align_center'       => false,
				'blogun_footer_visibility'                 => 'all',
				'blogun_footer_widget_heading_style'       => '0',
				'blogun_footer_heading_design_options'     => false,
				'blogun_footer_background'                 => blogun_design_options_defaults(
					array(
						'background' => array(
							'color'    => array(
								'background-color' => '#FFFFFF',
							),
							'gradient' => array(),
							'image'    => array(),
						),
					)
				),
				'blogun_footer_text_color'                 => blogun_design_options_defaults(
					array(
						'color' => array(
							'text-color'         => '#94979e',
							'link-color'         => '#44464b',
							'link-hover-color'   => '#ff4c60',
							'widget-title-color' => '#131315',
						),
					)
				),
				'blogun_footer_border'                     => blogun_design_options_defaults(
					array(
						'border' => array(
							'border-top-width'    => 7,
							'border-bottom-width' => 0,
							'border-color'        => '',
							'border-style'        => 'solid',
						),
					)
				),
				'blogun_typography_main_footer_heading'    => false,
			);

			$defaults = apply_filters( 'blogun_default_option_values', $defaults );
			return $defaults;
		}

		/**
		 * Get the options from static array()
		 *
		 * @since  1.0.0
		 * @return array    Return array of theme options.
		 */
		public function get_options() {
			return self::$options;
		}

		/**
		 * Get the options from static array().
		 *
		 * @since  1.0.0
		 * @param string $id Options jet to get.
		 * @return array Return array of theme options.
		 */
		public function get( $id ) {
			$value = isset( self::$options[ $id ] ) ? self::$options[ $id ] : self::get_default( $id );
			$value = apply_filters("theme_mod_{$id}", $value); // phpcs:ignore
			return $value;
		}

		/**
		 * Set option.
		 *
		 * @since  1.0.0
		 * @param string $id Option key.
		 * @param any    $value Option value.
		 * @return void
		 */
		public function set( $id, $value ) {
			set_theme_mod( $id, $value );
			self::$options[ $id ] = $value;
		}

		/**
		 * Refresh options.
		 *
		 * @since  1.0.0
		 * @return void
		 */
		public function refresh() {
			self::$options = wp_parse_args(
				get_theme_mods(),
				self::get_defaults()
			);
		}

		/**
		 * Returns the default value for option.
		 *
		 * @since  1.0.0
		 * @param  string $id Option ID.
		 * @return mixed      Default option value.
		 */
		public function get_default( $id ) {
			$defaults = self::get_defaults();
			return isset( $defaults[ $id ] ) ? $defaults[ $id ] : false;
		}
	}

endif;
