<?php //phpcs:ignore
/**
 * Theme functions and definitions.
 *
 * @package Blogun
 * @author Peregrine Themes
 * @since   1.0.0
 */

/**
 * Main Blogun class.
 *
 * @since 1.0.0
 */
final class Blogun {

	/**
	 * Theme options
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $options;

	/**
	 * Theme fonts
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $fonts;

	/**
	 * Theme icons
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $icons;

	/**
	 * Theme customizer
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $customizer;

	/**
	 * Theme admin
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $admin;

	/**
	 * Singleton instance of the class.
	 *
	 * @since 1.0.0
	 * @var object
	 */
	private static $instance;
	/**
	 * Theme version.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public $version = '1.0.12';
	/**
	 * Main Blogun Instance.
	 *
	 * Insures that only one instance of Blogun exists in memory at any one
	 * time. Also prevents needing to define globals all over the place.
	 *
	 * @since 1.0.0
	 * @return Blogun
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Blogun ) ) {
			self::$instance = new Blogun();
			self::$instance->constants();
			self::$instance->includes();
			self::$instance->objects();
			// Hook now that all of the Blogun stuff is loaded.
			do_action( 'blogun_loaded' );
		}
		return self::$instance;
	}
	/**
	 * Primary class constructor.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'blogun_setup_theme' ) );
		add_action( 'after_switch_theme', array( $this, 'blogun_delete_theme_demos_transient' ) );
	}
	/**
	 * Setup constants.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	private function constants() {
		if ( ! defined( 'BLOGUN_THEME_VERSION' ) ) {
			define( 'BLOGUN_THEME_VERSION', $this->version );
		}
		if ( ! defined( 'BLOGUN_THEME_URI' ) ) {
			define( 'BLOGUN_THEME_URI', get_parent_theme_file_uri() );
		}
		if ( ! defined( 'BLOGUN_THEME_PATH' ) ) {
			define( 'BLOGUN_THEME_PATH', get_parent_theme_file_path() );
		}
	}
	/**
	 * Include files.
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function includes() {
		require_once BLOGUN_THEME_PATH . '/inc/common.php';
		require_once BLOGUN_THEME_PATH . '/inc/helpers.php';
		require_once BLOGUN_THEME_PATH . '/inc/widgets.php';
		require_once BLOGUN_THEME_PATH . '/inc/template-tags.php';
		require_once BLOGUN_THEME_PATH . '/inc/template-parts.php';
		require_once BLOGUN_THEME_PATH . '/inc/icon-functions.php';
		require_once BLOGUN_THEME_PATH . '/inc/breadcrumbs.php';
		require_once BLOGUN_THEME_PATH . '/inc/class-blogun-dynamic-styles.php';
		// Core.
		require_once BLOGUN_THEME_PATH . '/inc/core/class-blogun-options.php';
		require_once BLOGUN_THEME_PATH . '/inc/core/class-blogun-enqueue-scripts.php';
		require_once BLOGUN_THEME_PATH . '/inc/core/class-blogun-fonts.php';
		require_once BLOGUN_THEME_PATH . '/inc/core/class-blogun-theme-setup.php';
		// Compatibility.
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/woocommerce/class-blogun-woocommerce.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/socialsnap/class-blogun-socialsnap.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-wpforms.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-jetpack.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-beaver-themer.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-elementor.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-elementor-pro.php';
		require_once BLOGUN_THEME_PATH . '/inc/compatibility/class-blogun-hfe.php';

		if ( is_admin() ) {
			require_once BLOGUN_THEME_PATH . '/inc/utilities/class-blogun-plugin-utilities.php';
			require_once BLOGUN_THEME_PATH . '/inc/admin/class-blogun-admin.php';

		}
		new Blogun_Enqueue_Scripts();
		// Customizer.
		require_once BLOGUN_THEME_PATH . '/inc/customizer/class-blogun-customizer.php';
		require_once BLOGUN_THEME_PATH . '/inc/customizer/customizer-callbacks.php';
		require_once BLOGUN_THEME_PATH . '/inc/customizer/class-blogun-section-ordering.php';
	}
	/**
	 * Setup objects to be used throughout the theme.
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function objects() {

		blogun()->options    = new Blogun_Options();
		blogun()->fonts      = new Blogun_Fonts();
		blogun()->icons      = new Blogun_Icons();
		blogun()->customizer = new Blogun_Customizer();
		if ( is_admin() ) {
			blogun()->admin = new Blogun_Admin();
		}
	}

	/**
	 * Blogun setup theme.
	 *
	 * @since 1.0.0
	 */
	public function blogun_setup_theme() {
		add_theme_support(
			'custom-header',
			apply_filters(
				'blogun_custom_header_args',
				array(
					'default-image' => '',
					'width'         => 1920,
					'height'        => 250,
					'flex-height'   => true,
					'header-text'   => false,
				)
			)
		);

		add_theme_support( 'custom-background', array( 'default-color' => '#f0f2f5' ) );

		add_theme_support(
			'starter-content',
			array(
				'widgets' => array(
					'blogun-footer-1' => array(
						'search',
					),
					'blogun-footer-2' => array(
						'categories',
					),
					'blogun-footer-3' => array(
						'archives',
					),
					'blogun-footer-4' => array(
						'meta',
					),
				),
			)
		);
	}

	/**
	 * Delete theme demos transient when switching from other Peregrine's themes to Blogun
	 *
	 * @since 1.0.0
	 */
	public function blogun_delete_theme_demos_transient() {
		// Delete theme demos transient
		delete_transient( 'hester_core_demo_templates' );
	}
}

/**
 * The function which returns the one Blogun instance.
 *
 * Use this function like you would a global variable, except without needing
 * to declare the global.
 *
 * Example: <?php $blogun = blogun(); ?>
 *
 * @since 1.0.0
 * @return object
 */
function blogun() {
	return Blogun::instance();
}

blogun();

