<?php
/**
 * Theme functions related to structure.
 *
 * This file contains structural hook functions.
 *
 * @package BlogTour
 */

if ( ! function_exists( 'blogtour_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since 1.0.0
	 */
function blogtour_doctype() {
	?><!DOCTYPE html> <html <?php language_attributes(); ?>><?php
}
endif;

add_action( 'blogtour_action_doctype', 'blogtour_doctype', 10 );


if ( ! function_exists( 'blogtour_head' ) ) :
	/**
	 * Header Codes.
	 *
	 * @since 1.0.0
	 */
function blogtour_head() {
	?>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif;
	
}
endif;
add_action( 'blogtour_action_head', 'blogtour_head', 10 );

if ( ! function_exists( 'blogtour_page_start' ) ) :
	/**
	 * Add Skip to content.
	 *
	 * @since 1.0.0
	 */
	function blogtour_page_start() {
	?><div id="page" class="site"><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'blogtour' ); ?></a><?php
	}
endif;

add_action( 'blogtour_action_before', 'blogtour_page_start', 10 );

if ( ! function_exists( 'blogtour_header_start' ) ) :
	/**
	 * Header Start.
	 *
	 * @since 1.0.0
	 */
	function blogtour_header_start() {

         ?>
		<header id="masthead" class="site-header nav-shrink" role="banner"><?php
	}
endif;
add_action( 'blogtour_action_before_header', 'blogtour_header_start' );

if ( ! function_exists( 'blogtour_header_end' ) ) :
	/**
	 * Header Start.
	 *
	 * @since 1.0.0
	 */
	function blogtour_header_end() {

		?></header> <!-- header ends here --><?php
	}
endif;
add_action( 'blogtour_action_header', 'blogtour_header_end', 15 );

if ( ! function_exists( 'blogtour_content_start' ) ) :
	/**
	 * Header End.
	 *
	 * @since 1.0.0
	 */
	function blogtour_content_start() { 
	?>
	<div id="content" class="site-content">
	<?php 

	}
endif;

add_action( 'blogtour_action_before_content', 'blogtour_content_start', 10 );

if ( ! function_exists( 'blogtour_footer_start' ) ) :
	/**
	 * Footer Start.
	 *
	 * @since 1.0.0
	 */
	function blogtour_footer_start() {
		if( !(is_home() || is_front_page()) ){
			echo '</div>';
		} ?>
		</div>
		<footer id="colophon" class="site-footer" role="contentinfo"><?php
		if ( true === blogtour_get_option('scroll_top_visible') ) : ?>
			<div class="backtotop"><i class="fa fa-chevron-up"></i></div>
		<?php endif;
	} 
endif;
add_action( 'blogtour_action_before_footer', 'blogtour_footer_start' );


if ( ! function_exists( 'blogtour_footer_end' ) ) :
	/**
	 * Footer End.
	 *
	 * @since 1.0.0
	 */
	function blogtour_footer_end() {?>
		</footer><?php
	}
endif;
add_action( 'blogtour_action_after_footer', 'blogtour_footer_end', 100 );

