<?php
/**
 * Features options.
 *
 * @package BlogTour
 */

$default = blogtour_get_default_theme_options();

// Features Section
$wp_customize->add_section( 'section_home_popular',
	array(
		'title'      => __( 'Popular Posts ', 'blogtour' ),
		'priority'   => 30,
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_popular_section]',
	array(
		'default'           => $default['disable_popular_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'blogtour_sanitize_switch_control',
	)
);
$wp_customize->add_control( new BlogTour_Switch_Control( $wp_customize, 'theme_options[disable_popular_section]',
    array(
		'label' 			=> __('Enable/Disable Features Section', 'blogtour'),
		'section'    		=> 'section_home_popular',
		 'settings'  		=> 'theme_options[disable_popular_section]',
		'on_off_label' 		=> blogtour_switch_options(),
    )
) );

//Features Section title
$wp_customize->add_setting('theme_options[popular_title]', 
	array(
	'default'           => $default['popular_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[popular_title]', 
	array(
	'label'       => __('Section Title', 'blogtour'),
	'section'     => 'section_home_popular',   
	'settings'    => 'theme_options[popular_title]',
	'active_callback' => 'blogtour_popular_active',		
	'type'        => 'text'
	)
);


$wp_customize->add_setting( 'theme_options[circle_image]',
	array(
		'default'           => $default['circle_image'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'blogtour_sanitize_switch_control',
	)
);
$wp_customize->add_control( new BlogTour_Switch_Control( $wp_customize, 'theme_options[circle_image]',
    array(
		'label' 			=> __('Enable/Disable circle image ', 'blogtour'),
		'section'    		=> 'section_home_popular',
		 'settings'  		=> 'theme_options[circle_image]',
		'on_off_label' 		=> blogtour_switch_options(),
		'active_callback' 	=> 'blogtour_popular_active',
    )
) );

// Number of items
$wp_customize->add_setting('theme_options[number_of_popular_items]', 
	array(
	'default' 			=> $default['number_of_popular_items'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'blogtour_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[number_of_popular_items]', 
	array(
	'label'       => __('Number Of Features', 'blogtour'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 5.(Pro MAX 25)', 'blogtour'),
	'section'     => 'section_home_popular',   
	'settings'    => 'theme_options[number_of_popular_items]',		
	'type'        => 'number',
	'active_callback' => 'blogtour_popular_active',
	'input_attrs' => array(
			'min'	=> 1,
			'max'	=> 5,
			'step'	=> 1,
		),
	)
);

// Setting  Blog Category.
$wp_customize->add_setting( 'theme_options[popular_category]',
	array(

	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new blogtour_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[popular_category]',
		array(
		'label'    => __( 'Select Category', 'blogtour' ),
		'section'  => 'section_home_popular',
		'settings' => 'theme_options[popular_category]',	
		'active_callback' => 'blogtour_popular_active',		
		'priority' => 100,
		)
	)
);

