<?php
/**
 * About options.
 *
 * @package BlogTour
 */

$default = blogtour_get_default_theme_options();

// About Author Section
$wp_customize->add_section( 'section_home_about',
	array(
		'title'      => __( 'About', 'blogtour' ),
		'priority'   => 20,
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_about_section]',
	array(
		'default'           => $default['disable_about_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'blogtour_sanitize_switch_control',
	)
);
$wp_customize->add_control( new BlogTour_Switch_Control( $wp_customize, 'theme_options[disable_about_section]',
    array(
		'label' 			=> __('Enable/Disable About Section', 'blogtour'),
		'section'    		=> 'section_home_about',
		 'settings'  		=> 'theme_options[disable_about_section]',
		'on_off_label' 		=> blogtour_switch_options(),
    )
) );

for( $i=1; $i<=4; $i++ ){

	// Posts
	$wp_customize->add_setting('theme_options[about_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'blogtour_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[about_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'blogtour'), $i),
		'section'     => 'section_home_about',   
		'settings'    => 'theme_options[about_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => blogtour_post_choices(),
		'active_callback' => 'blogtour_about_active',
		)
	);
}