<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function blogtour_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'blogtour' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'blogtour_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function blogtour_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'blogtour' ),
            'off'       => esc_html__( 'Disable', 'blogtour' )
        );
        return apply_filters( 'blogtour_switch_options', $arr );
    }
endif;


 /**
 * Get an array of google fonts.
 * 
 */
function blogtour_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'blogtour' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'blogtour_font_choices', $font_family_arr );
}

if ( ! function_exists( 'blogtour_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function blogtour_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'blogtour' ),
            'header-font-1'   => esc_html__( 'Raleway', 'blogtour' ),
            'header-font-2'   => esc_html__( 'Poppins', 'blogtour' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'blogtour' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'blogtour' ),
            'header-font-5'   => esc_html__( 'Lato', 'blogtour' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'blogtour' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'blogtour' ),
            'header-font-8'   => esc_html__( 'Lora', 'blogtour' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'blogtour' ),
            'header-font-10'   => esc_html__( 'Muli', 'blogtour' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'blogtour' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'blogtour' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'blogtour' ),
            'header-font-14'   => esc_html__( 'Cairo', 'blogtour' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'blogtour' ),
        );

        $output = apply_filters( 'blogtour_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'blogtour_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function blogtour_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'blogtour' ),
            'body-font-1'     => esc_html__( 'Raleway', 'blogtour' ),
            'body-font-2'     => esc_html__( 'Poppins', 'blogtour' ),
            'body-font-3'     => esc_html__( 'Roboto', 'blogtour' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'blogtour' ),
            'body-font-5'     => esc_html__( 'Lato', 'blogtour' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'blogtour' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'blogtour' ),
            'body-font-8'   => esc_html__( 'Lora', 'blogtour' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'blogtour' ),
            'body-font-10'   => esc_html__( 'Muli', 'blogtour' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'blogtour' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'blogtour' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'blogtour' ),
            'body-font-14'   => esc_html__( 'Cairo', 'blogtour' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'blogtour' ),
        );

        $output = apply_filters( 'blogtour_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>