<?php
/**
 * Default theme options.
 *
 * @package BlogTour
 */

if ( ! function_exists( 'blogtour_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function blogtour_get_default_theme_options() {

	$theme_data = wp_get_theme();
	$defaults = array();
	$defaults['header_textcolor'] = '#0e5bd6';

	$defaults['disable_homepage_content_section']	= true;

    $defaults['disable_header_background_section'] = false;

	// Featured Slider Section
	$defaults['disable_featured-slider_section']	= false;
	$defaults['number_of_sr_items']			= 3;
	$defaults['slider_speed']				= 800;
	$defaults['disable_white_overlay']		= true;


	// Popular Section
	$defaults['disable_popular_section']	= false;
	$defaults['popular_title']	   	 		= esc_html__( 'Popular Posts', 'blogtour' );
	$defaults['number_of_popular_items']	= 5;
	$defaults['circle_image']				= true;

	// Latest Posts Section

	$defaults['latest_posts_title']	   	 	= esc_html__( 'Latest Posts', 'blogtour' );
	$defaults['number_of_latest_posts_column']	= 3;
	$defaults['pagination_type']		= 'default';

	// About Section
	$defaults['disable_about_section']	= false;
	

	//General Section
	$defaults['readmore_text']				= esc_html__('Read More','blogtour');
	$defaults['excerpt_length']				= 20;
	$defaults['layout_options_blog']			= 'no-sidebar';
	$defaults['layout_options_archive']			= 'right-sidebar';
	$defaults['layout_options_page']			= 'right-sidebar';	
	$defaults['layout_options_single']			= 'right-sidebar';	

	//Footer section 		
	$defaults['copyright_text']				= esc_html__( 'Copyright &copy; All rights reserved.', 'blogtour' );

	// Pass through filter.
	$defaults = apply_filters( 'blogtour_filter_default_theme_options', $defaults );
	return $defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'blogtour_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function blogtour_get_option( $key ) {

		$default_options = blogtour_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;