<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package BlogTour
 */
/**
* Hook - blogtour_action_doctype.
*
* @hooked blogtour_doctype -  10
*/
do_action( 'blogtour_action_doctype' );
?>
<head>
<?php
/**
* Hook - blogtour_action_head.
*
* @hooked blogtour_head -  10
*/
do_action( 'blogtour_action_head' );
?>

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<?php

/**
* Hook - blogtour_action_before.
*
* @hooked blogtour_page_start - 10
*/
do_action( 'blogtour_action_before' );

/**
*
* @hooked blogtour_header_start - 10
*/
do_action( 'blogtour_action_before_header' );

/**
*
*@hooked blogtour_site_branding - 10
*@hooked blogtour_header_end - 15 
*/
do_action('blogtour_action_header');

/**
*
* @hooked blogtour_content_start - 10
*/
do_action( 'blogtour_action_before_content' );

/**
 * Banner start
 * 
 * @hooked blogtour_banner_header - 10
*/
do_action( 'blogtour_banner_header' );  
