<?php
/**
 * Theme functions and definitions
 *
 * @package Blogread
 */

if ( ! function_exists( 'blogread_enqueue_styles' ) ) :
	/**
	 * @since 0.1
	 */
	function blogread_enqueue_styles() {
		wp_enqueue_style( 'blogdata-style-parent', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'blogread-style', get_stylesheet_directory_uri() . '/style.css', array( 'blogdata-style-parent' ), '1.0' );
		wp_enqueue_style( 'blogread-default-css', get_stylesheet_directory_uri()."/css/colors/default.css" );
		wp_enqueue_style( 'blogread-dark', get_stylesheet_directory_uri() . '/css/colors/dark.css');

		if(is_rtl()){
			wp_enqueue_style( 'blogdata_style_rtl', trailingslashit( get_template_directory_uri() ) . 'style-rtl.css' );
	    }
		
	}

endif;
add_action( 'wp_enqueue_scripts', 'blogread_enqueue_styles', 9999 );

function blogread_customizer_rid_values($wp_customize) {

	$wp_customize->remove_section('header_advert_section');
	$wp_customize->remove_control('main_trending_post_section_title');
	$wp_customize->remove_control('select_trending_news_category');
	
}
add_action( 'customize_register', 'blogread_customizer_rid_values', 1000 );

function blogread_theme_setup() {
	//Load text domain for translation-ready
	load_theme_textdomain('blogread', get_stylesheet_directory() . '/languages');

	require( get_stylesheet_directory() . '/customizer-default.php' );
	require( get_stylesheet_directory() . '/general-options.php' );
	require( get_stylesheet_directory() . '/hooks/header-hook.php' );
	require( get_stylesheet_directory() . '/hooks/main-featured-slider-hook.php' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );
} 
add_action( 'after_setup_theme', 'blogread_theme_setup' );


if( ! function_exists( 'blogread_add_menu_description' ) ) :
    
    function blogread_add_menu_description( $item_output, $item, $depth, $args ) {
        if($args->theme_location != 'primary') return $item_output;
        
        if ( !empty( $item->description ) ) {
            $item_output = str_replace( $args->link_after . '</a>', '<span class="menu-link-description">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
        }
        return $item_output;
    }
    add_filter( 'walker_nav_menu_start_el', 'blogread_add_menu_description', 10, 4 );
endif;

$args = array(
    'default-color' => '#f4f4f4',
    'default-image' => '',
	);
add_theme_support( 'custom-background', $args );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function blogread_widgets_init() {

	$blogdata_footer_column_layout = esc_attr(get_theme_mod('blogdata_footer_column_layout',3));
	
	$blogdata_footer_column_layout = 12 / $blogdata_footer_column_layout;
	
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Widget Area', 'blogread' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="bs-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="bs-widget-title"><h2 class="title">',
		'after_title'   => '</h2></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area', 'blogread' ),
		'id'            => 'footer_widget_area',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="col-md-'.$blogdata_footer_column_layout.' rotateInDownLeft animated bs-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="bs-widget-title"><h2 class="title">',
		'after_title'   => '</h2></div>',
	) );

}
add_action( 'widgets_init', 'blogread_widgets_init' );

function blogread_custom_css(){ ?>
<style>
	:root {
		--wrap-color: <?php echo esc_attr(get_theme_mod('body_background_color','#ededf7')); ?>;
	}
	
	.site-branding-text .site-title a:hover{
		color: <?php echo esc_attr(get_theme_mod('header_text_color_on_hover','#8e54e9'))?> !important;
	}
	body.dark .site-branding-text .site-title a:hover{
		color: <?php echo esc_attr(get_theme_mod('header_text_dark_color_on_hover','#8e54e9'))?> !important;
	}
</style>
<?php
} 
add_action('wp_footer', 'blogread_custom_css',999);

function blogread_customizer_styles() {
	?>
	<style>
		body #accordion-section-blogdata_pro_upsell h3 .button-secondary:hover{
			color: #8e54e9 !important;
			border-color: currentcolor;
		}
	</style>
	<?php
}
add_action('customize_controls_enqueue_scripts', 'blogread_customizer_styles');