<?php
	$options  = blogmax_get_theme_options();
	$header_txt_logo_extra = $options['header_txt_logo_extra'];
?>

	<div class="menu-overlay"></div>

	<?php if($options['topbar_section_enable']) : ?>

	<div id="top-navigation" class="relative">
		<div class="wrapper">
			<button class="menu-toggle" aria-controls="secondary-menu" aria-expanded="false">
				<?php
					echo blogmax_get_svg( array( 'icon' => 'menu', 'class' => 'icon-menu' ) );
					echo blogmax_get_svg( array( 'icon' => 'close', 'class' => 'icon-menu' ) );
				?>
				<span class="menu-label"><?php _e('Top Menu', 'blogmax-news'); ?></span>
			</button><!-- .menu-toggle -->

			<nav id="secondary-navigation" class="main-navigation" role="navigation" aria-label="Secondary Menu">
				<?php  
					$social_html = null;
					if( $options['social_menu_enable'] && has_nav_menu( 'social' ) ): 
						$social_html = sprintf(
							'<li class="social-menu-item">%1$s</li>',
								wp_nav_menu( 
									array(
										'theme_location' => 'social',
										'container' => 'div',
										'container_class' => 'social-icons',
										'echo' => false,
										'depth' => 1,
										'link_before' => '<span class="screen-reader-text">',
										'link_after' => '</span>',
										'fallback_cb' => false,
									)
								)
							);
					else:
						$social_html = '';
					endif;

					wp_nav_menu( 
						array(
							'theme_location' => 'secondary',
							'container' => 'div',
							'menu_class' => 'menu nav-menu',
							'menu_id' => 'secondary-menu',
							'echo' => true,
							'fallback_cb' => 'blogmax_menu_fallback_cb',
							'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s'.$social_html.'</ul>',
						)
					);

				?>        
			</nav><!-- .main-navigation-->
		</div>
	</div><!-- #top-navigation -->

	<?php endif; ?>

	<header id="masthead" class="site-header" role="banner">
		<div class="wrapper">
			<div class="site-branding-wrapper">
				<div class="site-branding">
					<?php if ( in_array( $header_txt_logo_extra, array( 'show-all', 'logo-title', 'logo-tagline' ) ) && has_custom_logo()  ) : ?>
						<div class="site-logo">
							<?php the_custom_logo(); ?>
						</div>
					<?php endif; 

					if ( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline' ) ) ) : ?>
						<div id="site-identity">
							<?php
							if( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title' ) )  ) {
								if ( blogmax_is_latest_posts() ) : ?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
								<?php else : ?>
									<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
								<?php
								endif;
							} 
							if ( in_array( $header_txt_logo_extra, array( 'show-all', 'tagline-only', 'logo-tagline' ) ) ) {
								$description = get_bloginfo( 'description', 'display' );
								if ( $description || is_customize_preview() ) : ?>
									<p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
								<?php
								endif; 
							}?>
						</div>
					<?php endif; ?>
				</div>
				<?php if ( ! empty( get_theme_mod( 'ads_image' ) ) && ! empty( get_theme_mod( 'ads_url' ) ) ) : ?>
					<div class="site-advertisement">
						<a href="<?php echo esc_url( get_theme_mod( 'ads_url' ) ); ?>"><img src="<?php echo esc_url( get_theme_mod( 'ads_image' ) ); ?>"></a>
					</div><!-- .site-advertisement -->
				<?php endif; ?>
			</div>
			<div class="site-wrapper">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" title="Primary Menu">
				<?php
					echo blogmax_get_svg( array( 'icon' => 'menu', 'class' => 'icon-menu' ) );
					echo blogmax_get_svg( array( 'icon' => 'close', 'class' => 'icon-menu' ) );
				?>	
					<span class="menu-label"><?php esc_html_e('Menu', 'blogmax-news')?></span>		
			</button>

			<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
				
				<?php  

				$search_html = sprintf(
					'<li class="search-menu"><a href="#" title="%1$s">%2$s%3$s</a><div id="search">%4$s</div>',
					esc_attr__('Search','blogmax-news'),
					blogmax_get_svg( array( 'icon' => 'search' ) ), 
					blogmax_get_svg( array( 'icon' => 'close' ) ), 
					get_search_form( $echo = false )
				);

				wp_nav_menu( array(
					'theme_location' => 'primary',
					'container' => 'div',
					'menu_class' => 'menu nav-menu',
					'menu_id' => 'primary-menu',
					'echo' => true,
					'fallback_cb' => 'blogmax_menu_fallback_cb',
					'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s'.$search_html.'</ul>',
				) );


				?>
			</nav><!-- #site-navigation -->
			</div>
		</div>
	</header><!-- .header-->

<?php