<?php

if ( ! function_exists( 'blogmax_news_add_highlighted_posts_section' ) ) :

    function blogmax_news_add_highlighted_posts_section() {
        
        if ( get_theme_mod( 'highlighted_posts_section_enable' ) == false ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'blogmax_news_filter_highlighted_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        blogmax_news_render_highlighted_posts_section( $section_details );
    }

endif;

if ( ! function_exists( 'blogmax_news_get_highlighted_posts_section_details' ) ) :

    function blogmax_news_get_highlighted_posts_section_details( $input ) {
        $content  = array();
        $post_ids = array();
        for ( $i = 1; $i <= 5; $i++ ) {
            if ( ! empty( get_theme_mod( 'highlighted_posts_content_post_'.$i ) ) )
                $post_ids[] = get_theme_mod( 'highlighted_posts_content_post_'.$i );
        }

        $args = array(
            'post_type'         => 'post',
            'post__in'          => ( array ) $post_ids,
            'posts_per_page'    => absint( 5 ),
            'orderby'           => 'post__in',
        );

            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = blogmax_trim_content( 25 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

add_filter( 'blogmax_news_filter_highlighted_posts_section_details', 'blogmax_news_get_highlighted_posts_section_details' );


if ( ! function_exists( 'blogmax_news_render_highlighted_posts_section' ) ) :

   function blogmax_news_render_highlighted_posts_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="blogmax_highlighted_posts_section" class="relative page-section same-background">
            <div class="wrapper">
                <div class="col-3 grid clear">
                    <?php foreach ($content_details as $content ): ?>
                        <article class="grid-item">
                            <div class="highlighted-post-item">
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>">
                                </div>

                                <div class="entry-container">
                                    <?php the_category( '', '', $content['id'] ); ?>

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                    </header>   

                                    <?php blogmax_posted_on( $content['id'] ) ; ?>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
              
<?php    }
endif;