<?php

if ( ! function_exists( 'blogmax_news_add_advertisement_section' ) ) :

    function blogmax_news_add_advertisement_section() {

        $advertisement_enable = apply_filters( 'blogmax_news_section_status', true, 'advertisement_section_enable' );

        if ( true !== $advertisement_enable ) {
            return false;
        }

        blogmax_news_render_advertisement_section();
    }
endif;

if ( ! function_exists( 'blogmax_news_render_advertisement_section' ) ) :

   function blogmax_news_render_advertisement_section() {
        ?>
        <?php if ( ! empty( get_theme_mod( 'advertisement_ads_image' ) ) && ! empty( get_theme_mod( 'advertisement_ads_url' ) ) ) : ?>
            <div id="blogmax_advertisement_section" class="relative page-section same-background">
                <div class="wrapper">
                    <a href="<?php echo esc_url( get_theme_mod( 'advertisement_ads_url' ) ); ?>"><img src="<?php echo esc_html( get_theme_mod( 'advertisement_ads_image' ) ); ?>"></a>
                </div>
            </div>
        <?php endif; ?>
    <?php }
endif; 