<?php

// Add Trending Posts section
$wp_customize->add_section( 'blogmax_trending_posts_section',
    array(
        'title'             => esc_html__( 'Trending Posts','blogmax-news' ),
        'description'       => esc_html__( 'Trending Posts Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 32,
    )
);

// Trending Posts content enable control and setting
$wp_customize->add_setting( 'trending_posts_section_enable]',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'trending_posts_section_enable',
        array(
            'label'             => esc_html__( 'Trending Posts Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_trending_posts_section',
            'on_off_label'      => blogmax_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'trending_posts_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Trending Posts', 'blogmax-news' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'trending_posts_title',
    array(
        'label'             => esc_html__( 'Section Title', 'blogmax-news' ),
        'section'           => 'blogmax_trending_posts_section',
        'active_callback'   => 'blogmax_news_is_trending_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('trending_posts_title',
        array(
            'selector'            => '#blogmax_trending_posts_section .section-header h2',
            'settings'            => 'trending_posts_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogmax_news_trending_posts_title_partial',
        )
    );
}



for ( $i = 1; $i <= 4; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'trending_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'blogmax_sanitize_page',
        )
    );

    $wp_customize->add_control( new Blogmax_News_Dropdown_Chooser( $wp_customize,
        'trending_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'blogmax-news' ), $i ),
                'section'           => 'blogmax_trending_posts_section',
                'choices'           => blogmax_post_choices(),
                'active_callback'   => 'blogmax_news_is_trending_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('trending_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'blogmax_sanitize_html',
        )
    );

    $wp_customize->add_control(new Blogmax_News_Customize_Horizontal_Line($wp_customize,
        'trending_posts_separator'. $i,
            array(
                'active_callback'       => 'blogmax_news_is_trending_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'blogmax_trending_posts_section',
            )
        )
    );
    
endfor;